package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TInvestmentMapper;
import com.zehong.system.domain.TInvestment;
import com.zehong.system.service.ITInvestmentService;

/**
 * 投入台账Service业务层处理
 * 
 * @author zehong
 * @date 2022-06-24
 */
@Service
public class TInvestmentServiceImpl implements ITInvestmentService 
{
    @Autowired
    private TInvestmentMapper tInvestmentMapper;

    /**
     * 查询投入台账
     * 
     * @param id 投入台账ID
     * @return 投入台账
     */
    @Override
    public TInvestment selectTInvestmentById(Long id)
    {
        return tInvestmentMapper.selectTInvestmentById(id);
    }

    /**
     * 查询投入台账列表
     * 
     * @param tInvestment 投入台账
     * @return 投入台账
     */
    @Override
    public List<TInvestment> selectTInvestmentList(TInvestment tInvestment)
    {
        return tInvestmentMapper.selectTInvestmentList(tInvestment);
    }

    /**
     * 新增投入台账
     * 
     * @param tInvestment 投入台账
     * @return 结果
     */
    @Override
    public int insertTInvestment(TInvestment tInvestment)
    {
        tInvestment.setCreateTime(DateUtils.getNowDate());
        return tInvestmentMapper.insertTInvestment(tInvestment);
    }

    /**
     * 修改投入台账
     * 
     * @param tInvestment 投入台账
     * @return 结果
     */
    @Override
    public int updateTInvestment(TInvestment tInvestment)
    {
        tInvestment.setUpdateTime(DateUtils.getNowDate());
        return tInvestmentMapper.updateTInvestment(tInvestment);
    }

    /**
     * 批量删除投入台账
     * 
     * @param ids 需要删除的投入台账ID
     * @return 结果
     */
    @Override
    public int deleteTInvestmentByIds(Long[] ids)
    {
        return tInvestmentMapper.deleteTInvestmentByIds(ids);
    }

    /**
     * 删除投入台账信息
     * 
     * @param id 投入台账ID
     * @return 结果
     */
    @Override
    public int deleteTInvestmentById(Long id)
    {
        return tInvestmentMapper.deleteTInvestmentById(id);
    }
}
