package com.zehong.system.service.impl;

import java.text.SimpleDateFormat;
import java.util.*;

import com.alibaba.fastjson.JSON;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TInspectWorkPointRecorde;
import com.zehong.system.mapper.SysDeptMapper;
import com.zehong.system.mapper.TInspectWorkPointRecordeMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TInspectWorkInfoMapper;
import com.zehong.system.domain.TInspectWorkInfo;
import com.zehong.system.service.ITInspectWorkInfoService;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.Size;
import javax.xml.crypto.Data;

/**
 * 巡检任务信息Service业务层处理
 * 
 * @author zehong
 * @date 2022-06-20
 */
@Service
public class TInspectWorkInfoServiceImpl implements ITInspectWorkInfoService 
{
    @Autowired
    private TInspectWorkInfoMapper tInspectWorkInfoMapper;
    @Autowired
    private TInspectWorkPointRecordeMapper tInspectWorkPointRecordeMapper;
    @Autowired
    private SysDeptMapper sysDeptMapper;

    /**
     * 查询巡检任务信息
     * 
     * @param workId 巡检任务信息ID
     * @return 巡检任务信息
     */
    @Override
    public TInspectWorkInfo selectTInspectWorkInfoById(Long workId)
    {
        return tInspectWorkInfoMapper.selectTInspectWorkInfoById(workId);
    }

    /**
     * 查询巡检任务信息列表
     * 
     * @param tInspectWorkInfo 巡检任务信息
     * @return 巡检任务信息
     */
    @Override
    public List<TInspectWorkInfo> selectTInspectWorkInfoList(TInspectWorkInfo tInspectWorkInfo)
    {
        return tInspectWorkInfoMapper.selectTInspectWorkInfoList(tInspectWorkInfo);
    }
    @Override

    public List<TInspectWorkInfo> selectTInspectWorkInfoListChildren(TInspectWorkInfo tInspectWorkInfo)
    {
        tInspectWorkInfo.setParentId(0l);
        List<TInspectWorkInfo> list = tInspectWorkInfoMapper.selectTInspectWorkInfoList(tInspectWorkInfo);
        for (TInspectWorkInfo workInfo : list){
            List<TInspectWorkInfo> list2 = tInspectWorkInfoMapper.selectTInspectWorkInfoListLimit(workInfo.getWorkId());
            List<String> ids = (List<String>) JSON.parse(workInfo.getPantrolId());
            List<Long> longlist = new ArrayList<>();
            if(ids.size()>0){
                for(String id :ids){
                    id = id.split("-")[0];
                    longlist.add(Long.parseLong(id));
                }
                String names = sysDeptMapper.selectNamesByIds(longlist);
                workInfo.setDeptName(names);
            }
            workInfo.setChildren(list2);
        }

        return list;
    }

    @Override
    public List<TInspectWorkInfo> taskList(Long deptId) {
        TInspectWorkInfo tInspectWorkInfo = new TInspectWorkInfo();
        tInspectWorkInfo.setDeptId(deptId);
        return tInspectWorkInfoMapper.taskList(tInspectWorkInfo);
    }

    /**
     * 新增巡检任务信息
     * 
     * @param tInspectWorkInfo 巡检任务信息
     * @return 结果
     */
    @Override
    @Transactional
    public int insertTInspectWorkInfo(TInspectWorkInfo tInspectWorkInfo)
    {
        tInspectWorkInfo.setCreateTime(DateUtils.getNowDate());
        int a = tInspectWorkInfoMapper.insertTInspectWorkInfo(tInspectWorkInfo);
        //如果是单次任务需要把任务分配完成
        if(tInspectWorkInfo.getWorkType()==1){
            addWrokRecorde(tInspectWorkInfo);
        }
        return a;
    }
    /**
     * 修改巡检任务信息
     * 
     * @param tInspectWorkInfo 巡检任务信息
     * @return 结果
     */
    @Override
    public int updateTInspectWorkInfo(TInspectWorkInfo tInspectWorkInfo)
    {
        tInspectWorkInfo.setUpdateTime(DateUtils.getNowDate());
        return tInspectWorkInfoMapper.updateTInspectWorkInfo(tInspectWorkInfo);
    }

    /**
     * 批量删除巡检任务信息
     * 
     * @param workIds 需要删除的巡检任务信息ID
     * @return 结果
     */
    @Override
    public int deleteTInspectWorkInfoByIds(Long[] workIds)
    {
        return tInspectWorkInfoMapper.deleteTInspectWorkInfoByIds(workIds);
    }

    /**
     * 删除巡检任务信息信息
     * 
     * @param workId 巡检任务信息ID
     * @return 结果
     */
    @Override
    public int deleteTInspectWorkInfoById(Long workId)
    {
        return tInspectWorkInfoMapper.deleteTInspectWorkInfoById(workId);
    }

    /**
     * 定时发布任务
     */
    @Override
    @Transactional
    public void implementTiming(){
        Date d = new Date();

        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date begin = d;
        Date end = d;
        try {
             begin = dateFormat2.parse(dateFormat.format(d)+" 00:00:00") ;
             end = dateFormat2.parse(dateFormat.format(d)+" 23:59:59") ;
        }catch (Exception e){
            new Exception(e.getMessage());
        }

        //每天任务
        List<TInspectWorkInfo> list1= tInspectWorkInfoMapper.selectTInspectWorkInfoList2(2);
        for(TInspectWorkInfo work:list1){
            work.setWorkBeginTime(begin);
            work.setWorkLimitTime(end);
            addWrokRecorde(work);
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        if(c.get(Calendar.DAY_OF_WEEK)==2){
            //每周任务
            List<TInspectWorkInfo> list2= tInspectWorkInfoMapper.selectTInspectWorkInfoList2(3);
            for(TInspectWorkInfo work:list2){
                work.setWorkBeginTime(begin);
                work.setWorkLimitTime(end);
                addWrokRecorde(work);
            }
        }
        if(c.get(Calendar.DATE)==1){
            //每月任务
            List<TInspectWorkInfo> list3= tInspectWorkInfoMapper.selectTInspectWorkInfoList2(4);
            for(TInspectWorkInfo work:list3){
                work.setWorkBeginTime(begin);
                work.setWorkLimitTime(end);
                addWrokRecorde(work);
            }
            int month = c.get(Calendar.MONTH) + 1;
            if(month%3==1){
                //每季度任务
                List<TInspectWorkInfo> list4= tInspectWorkInfoMapper.selectTInspectWorkInfoList2(5);
                for(TInspectWorkInfo work:list4){
                    work.setWorkBeginTime(begin);
                    work.setWorkLimitTime(end);
                    addWrokRecorde(work);
                }
            }
        }
    }
    @Transactional
    public void  addWrokRecorde(TInspectWorkInfo tInspectWorkInfo){
        //所有部门巡检点id (部门-巡检点)
        List<String> ids = ( List<String>) JSON.parse(tInspectWorkInfo.getPantrolId());
        //存放结果集
        List<Map<String,Object>> mapList = new ArrayList<>();
        //循环处理部门与巡检点id
        for(String id:ids){
            String[] twoId = id.split("-");
            //第一个巡检点处理
            if(mapList.size()==0){
                Map<String,Object> onemap = new HashMap<>();
                onemap.put("deptId",twoId[0]);
                onemap.put("ids",twoId[1]);
                mapList.add(onemap);
            }else {
                int b = 0;
                for(Map<String,Object> map:mapList){//存在的部门原基础添加巡检点
                    if(map.get("deptId").equals(twoId[0])){
                        map.put("ids",map.get("ids")+","+twoId[1]);
                        b = 1;
                    }
                }
                if(b!=1){//没有存在过的添加新的部门巡检点
                    Map<String,Object> twomap = new HashMap<>();
                    twomap.put("deptId",twoId[0]);
                    twomap.put("ids",twoId[1]);
                    mapList.add(twomap);
                }
            }

        }
        //批量添加任务
        List<TInspectWorkInfo> list = new ArrayList<>();
        SimpleDateFormat format = new SimpleDateFormat("MM-dd");
        Date d = new Date();
        String data = format.format(d);
        for(Map<String,Object> map : mapList){
            TInspectWorkInfo workInfo = new TInspectWorkInfo();
            workInfo.setParentId(tInspectWorkInfo.getWorkId());
            workInfo.setWorkType(tInspectWorkInfo.getWorkType());
            workInfo.setWorkName(tInspectWorkInfo.getWorkName()+data);
            workInfo.setWorkBeginTime(tInspectWorkInfo.getWorkBeginTime());
            workInfo.setWorkLimitTime(tInspectWorkInfo.getWorkLimitTime());
            workInfo.setWorkDescribe(tInspectWorkInfo.getWorkDescribe());
            workInfo.setPantrolId( (String) map.get("ids"));
            workInfo.setDeptId(Long.parseLong((String) map.get("deptId")) );
            workInfo.setInspectPointNum( ((String) map.get("ids")).split(",").length);
            workInfo.setInspectSuccessNum(0);
            workInfo.setCreateTime(d);
            workInfo.setRemarks(tInspectWorkInfo.getRemarks());
            list.add(workInfo);
        }
        tInspectWorkInfoMapper.inserts(list);
        //批量添加记录
        List<TInspectWorkPointRecorde> recordeList = new ArrayList<>();
        for(TInspectWorkInfo workInfo:list){
            for (String id:workInfo.getPantrolId().split(",")){
                TInspectWorkPointRecorde recorde = new TInspectWorkPointRecorde();
                recorde.setWorkId(workInfo.getWorkId());
                recorde.setPatrolId(Long.parseLong(id));
                recorde.setCreateTime(new Date());
                recordeList.add(recorde);
            }
        }
        tInspectWorkPointRecordeMapper.inserts(recordeList);
    }
}
