package com.zehong.system.service.impl;

import java.util.Date;
import java.util.List;

import com.zehong.system.domain.THiddenTroubleWork;
import com.zehong.system.mapper.THiddenTroubleWorkMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.THiddenTroubleAssessmentMapper;
import com.zehong.system.domain.THiddenTroubleAssessment;
import com.zehong.system.service.ITHiddenTroubleAssessmentService;
import org.springframework.transaction.annotation.Transactional;

/**
 * 排查评估Service业务层处理
 * 
 * @author zehong
 * @date 2022-07-12
 */
@Service
public class THiddenTroubleAssessmentServiceImpl implements ITHiddenTroubleAssessmentService 
{
    @Autowired
    private THiddenTroubleAssessmentMapper tHiddenTroubleAssessmentMapper;
    @Autowired
    private THiddenTroubleWorkMapper tHiddenTroubleWorkMapper;

    /**
     * 查询排查评估
     * 
     * @param assessmentId 排查评估ID
     * @return 排查评估
     */
    @Override
    public THiddenTroubleAssessment selectTHiddenTroubleAssessmentById(Long assessmentId)
    {
        return tHiddenTroubleAssessmentMapper.selectTHiddenTroubleAssessmentById(assessmentId);
    }
    @Override
    public THiddenTroubleAssessment selectTHiddenTroubleAssessmentByWorkId(Long workId)
    {
        return tHiddenTroubleAssessmentMapper.selectTHiddenTroubleAssessmentByWorkId(workId);
    }

    /**
     * 查询排查评估列表
     * 
     * @param tHiddenTroubleAssessment 排查评估
     * @return 排查评估
     */
    @Override
    public List<THiddenTroubleAssessment> selectTHiddenTroubleAssessmentList(THiddenTroubleAssessment tHiddenTroubleAssessment)
    {
        return tHiddenTroubleAssessmentMapper.selectTHiddenTroubleAssessmentList(tHiddenTroubleAssessment);
    }

    /**
     * 新增排查评估
     * 
     * @param tHiddenTroubleAssessment 排查评估
     * @return 结果
     */
    @Override
    public int insertTHiddenTroubleAssessment(THiddenTroubleAssessment tHiddenTroubleAssessment)
    {
        return tHiddenTroubleAssessmentMapper.insertTHiddenTroubleAssessment(tHiddenTroubleAssessment);
    }

    /**
     * 修改排查评估
     * 
     * @param tHiddenTroubleAssessment 排查评估
     * @return 结果
     */
    @Override
    @Transactional
    public int updateTHiddenTroubleAssessment(THiddenTroubleAssessment tHiddenTroubleAssessment)
    {
        if(tHiddenTroubleAssessment.getUpdateType()==2){
            tHiddenTroubleAssessment.setAssessmentTime(new Date());
            THiddenTroubleWork work = tHiddenTroubleWorkMapper.selectTHiddenTroubleWorkById(tHiddenTroubleAssessment.getWorkId());
            work.setWorkStep(2);
            tHiddenTroubleWorkMapper.updateTHiddenTroubleWork(work);
            if(work.getParentId()!=0L){
                THiddenTroubleWork work1 = new THiddenTroubleWork();
                work1.setWorkId(work.getParentId());
                work1.setWorkStep(2);
                tHiddenTroubleWorkMapper.updateTHiddenTroubleWork(work1);
            }

        }
        return tHiddenTroubleAssessmentMapper.updateTHiddenTroubleAssessment(tHiddenTroubleAssessment);
    }

    /**
     * 批量删除排查评估
     * 
     * @param assessmentIds 需要删除的排查评估ID
     * @return 结果
     */
    @Override
    public int deleteTHiddenTroubleAssessmentByIds(Long[] assessmentIds)
    {
        return tHiddenTroubleAssessmentMapper.deleteTHiddenTroubleAssessmentByIds(assessmentIds);
    }

    /**
     * 删除排查评估信息
     * 
     * @param assessmentId 排查评估ID
     * @return 结果
     */
    @Override
    public int deleteTHiddenTroubleAssessmentById(Long assessmentId)
    {
        return tHiddenTroubleAssessmentMapper.deleteTHiddenTroubleAssessmentById(assessmentId);
    }
}
