package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.THiddenLibraryMapper;
import com.zehong.system.domain.THiddenLibrary;
import com.zehong.system.service.ITHiddenLibraryService;

/**
 * 隐患排查库Service业务层处理
 * 
 * @author zehong
 * @date 2022-07-13
 */
@Service
public class THiddenLibraryServiceImpl implements ITHiddenLibraryService 
{
    @Autowired
    private THiddenLibraryMapper tHiddenLibraryMapper;

    /**
     * 查询隐患排查库
     * 
     * @param libraryId 隐患排查库ID
     * @return 隐患排查库
     */
    @Override
    public THiddenLibrary selectTHiddenLibraryById(Long libraryId)
    {
        return tHiddenLibraryMapper.selectTHiddenLibraryById(libraryId);
    }

    /**
     * 查询隐患排查库列表
     * 
     * @param tHiddenLibrary 隐患排查库
     * @return 隐患排查库
     */
    @Override
    public List<THiddenLibrary> selectTHiddenLibraryList(THiddenLibrary tHiddenLibrary)
    {
        return tHiddenLibraryMapper.selectTHiddenLibraryList(tHiddenLibrary);
    }

    /**
     * 新增隐患排查库
     * 
     * @param tHiddenLibrary 隐患排查库
     * @return 结果
     */
    @Override
    public int insertTHiddenLibrary(THiddenLibrary tHiddenLibrary)
    {
        return tHiddenLibraryMapper.insertTHiddenLibrary(tHiddenLibrary);
    }

    /**
     * 修改隐患排查库
     * 
     * @param tHiddenLibrary 隐患排查库
     * @return 结果
     */
    @Override
    public int updateTHiddenLibrary(THiddenLibrary tHiddenLibrary)
    {
        return tHiddenLibraryMapper.updateTHiddenLibrary(tHiddenLibrary);
    }

    /**
     * 批量删除隐患排查库
     * 
     * @param libraryIds 需要删除的隐患排查库ID
     * @return 结果
     */
    @Override
    public int deleteTHiddenLibraryByIds(Long[] libraryIds)
    {
        return tHiddenLibraryMapper.deleteTHiddenLibraryByIds(libraryIds);
    }

    /**
     * 删除隐患排查库信息
     * 
     * @param libraryId 隐患排查库ID
     * @return 结果
     */
    @Override
    public int deleteTHiddenLibraryById(Long libraryId)
    {
        return tHiddenLibraryMapper.deleteTHiddenLibraryById(libraryId);
    }
}
