package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TEnterpriseInfoMapper;
import com.zehong.system.domain.TEnterpriseInfo;
import com.zehong.system.service.ITEnterpriseInfoService;

/**
 * 企业基础信息管理Service业务层处理
 * 
 * @author zehong
 * @date 2022-06-23
 */
@Service
public class TEnterpriseInfoServiceImpl implements ITEnterpriseInfoService 
{
    @Autowired
    private TEnterpriseInfoMapper tEnterpriseInfoMapper;

    /**
     * 查询企业基础信息管理
     * 
     * @param id 企业基础信息管理ID
     * @return 企业基础信息管理
     */
    @Override
    public TEnterpriseInfo selectTEnterpriseInfoById(Long id)
    {
        return tEnterpriseInfoMapper.selectTEnterpriseInfoById(id);
    }

    /**
     * 查询企业基础信息管理列表
     * 
     * @param tEnterpriseInfo 企业基础信息管理
     * @return 企业基础信息管理
     */
    @Override
    public List<TEnterpriseInfo> selectTEnterpriseInfoList(TEnterpriseInfo tEnterpriseInfo)
    {
        return tEnterpriseInfoMapper.selectTEnterpriseInfoList(tEnterpriseInfo);
    }

    /**
     * 新增企业基础信息管理
     * 
     * @param tEnterpriseInfo 企业基础信息管理
     * @return 结果
     */
    @Override
    public int insertTEnterpriseInfo(TEnterpriseInfo tEnterpriseInfo)
    {
        tEnterpriseInfo.setCreateTime(DateUtils.getNowDate());
        return tEnterpriseInfoMapper.insertTEnterpriseInfo(tEnterpriseInfo);
    }

    /**
     * 修改企业基础信息管理
     * 
     * @param tEnterpriseInfo 企业基础信息管理
     * @return 结果
     */
    @Override
    public int updateTEnterpriseInfo(TEnterpriseInfo tEnterpriseInfo)
    {
        tEnterpriseInfo.setUpdateTime(DateUtils.getNowDate());
        return tEnterpriseInfoMapper.updateTEnterpriseInfo(tEnterpriseInfo);
    }

    /**
     * 批量删除企业基础信息管理
     * 
     * @param ids 需要删除的企业基础信息管理ID
     * @return 结果
     */
    @Override
    public int deleteTEnterpriseInfoByIds(Long[] ids)
    {
        return tEnterpriseInfoMapper.deleteTEnterpriseInfoByIds(ids);
    }

    /**
     * 删除企业基础信息管理信息
     * 
     * @param id 企业基础信息管理ID
     * @return 结果
     */
    @Override
    public int deleteTEnterpriseInfoById(Long id)
    {
        return tEnterpriseInfoMapper.deleteTEnterpriseInfoById(id);
    }
}
