package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TEnterpriseCertificateMapper;
import com.zehong.system.domain.TEnterpriseCertificate;
import com.zehong.system.service.ITEnterpriseCertificateService;

/**
 * 企业资质证照管理Service业务层处理
 * 
 * @author zehong
 * @date 2022-06-23
 */
@Service
public class TEnterpriseCertificateServiceImpl implements ITEnterpriseCertificateService 
{
    @Autowired
    private TEnterpriseCertificateMapper tEnterpriseCertificateMapper;

    /**
     * 查询企业资质证照管理
     * 
     * @param id 企业资质证照管理ID
     * @return 企业资质证照管理
     */
    @Override
    public TEnterpriseCertificate selectTEnterpriseCertificateById(Long id)
    {
        return tEnterpriseCertificateMapper.selectTEnterpriseCertificateById(id);
    }

    /**
     * 查询企业资质证照管理列表
     * 
     * @param tEnterpriseCertificate 企业资质证照管理
     * @return 企业资质证照管理
     */
    @Override
    public List<TEnterpriseCertificate> selectTEnterpriseCertificateList(TEnterpriseCertificate tEnterpriseCertificate)
    {
        return tEnterpriseCertificateMapper.selectTEnterpriseCertificateList(tEnterpriseCertificate);
    }

    /**
     * 新增企业资质证照管理
     * 
     * @param tEnterpriseCertificate 企业资质证照管理
     * @return 结果
     */
    @Override
    public int insertTEnterpriseCertificate(TEnterpriseCertificate tEnterpriseCertificate)
    {
        tEnterpriseCertificate.setCreateTime(DateUtils.getNowDate());
        return tEnterpriseCertificateMapper.insertTEnterpriseCertificate(tEnterpriseCertificate);
    }

    /**
     * 修改企业资质证照管理
     * 
     * @param tEnterpriseCertificate 企业资质证照管理
     * @return 结果
     */
    @Override
    public int updateTEnterpriseCertificate(TEnterpriseCertificate tEnterpriseCertificate)
    {
        tEnterpriseCertificate.setUpdateTime(DateUtils.getNowDate());
        return tEnterpriseCertificateMapper.updateTEnterpriseCertificate(tEnterpriseCertificate);
    }

    /**
     * 批量删除企业资质证照管理
     * 
     * @param ids 需要删除的企业资质证照管理ID
     * @return 结果
     */
    @Override
    public int deleteTEnterpriseCertificateByIds(Long[] ids)
    {
        return tEnterpriseCertificateMapper.deleteTEnterpriseCertificateByIds(ids);
    }

    /**
     * 删除企业资质证照管理信息
     * 
     * @param id 企业资质证照管理ID
     * @return 结果
     */
    @Override
    public int deleteTEnterpriseCertificateById(Long id)
    {
        return tEnterpriseCertificateMapper.deleteTEnterpriseCertificateById(id);
    }
}
