package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TEmergencyDrillMapper;
import com.zehong.system.domain.TEmergencyDrill;
import com.zehong.system.service.ITEmergencyDrillService;

/**
 * 应急演练Service业务层处理
 * 
 * @author zehong
 * @date 2022-06-29
 */
@Service
public class TEmergencyDrillServiceImpl implements ITEmergencyDrillService 
{
    @Autowired
    private TEmergencyDrillMapper tEmergencyDrillMapper;

    /**
     * 查询应急演练
     * 
     * @param drillId 应急演练ID
     * @return 应急演练
     */
    @Override
    public TEmergencyDrill selectTEmergencyDrillById(Long drillId)
    {
        return tEmergencyDrillMapper.selectTEmergencyDrillById(drillId);
    }

    /**
     * 查询应急演练列表
     * 
     * @param tEmergencyDrill 应急演练
     * @return 应急演练
     */
    @Override
    public List<TEmergencyDrill> selectTEmergencyDrillList(TEmergencyDrill tEmergencyDrill)
    {
        return tEmergencyDrillMapper.selectTEmergencyDrillList(tEmergencyDrill);
    }

    /**
     * 新增应急演练
     * 
     * @param tEmergencyDrill 应急演练
     * @return 结果
     */
    @Override
    public int insertTEmergencyDrill(TEmergencyDrill tEmergencyDrill)
    {
        tEmergencyDrill.setCreateTime(DateUtils.getNowDate());
        return tEmergencyDrillMapper.insertTEmergencyDrill(tEmergencyDrill);
    }

    /**
     * 修改应急演练
     * 
     * @param tEmergencyDrill 应急演练
     * @return 结果
     */
    @Override
    public int updateTEmergencyDrill(TEmergencyDrill tEmergencyDrill)
    {
        return tEmergencyDrillMapper.updateTEmergencyDrill(tEmergencyDrill);
    }

    /**
     * 批量删除应急演练
     * 
     * @param drillIds 需要删除的应急演练ID
     * @return 结果
     */
    @Override
    public int deleteTEmergencyDrillByIds(Long[] drillIds)
    {
        return tEmergencyDrillMapper.deleteTEmergencyDrillByIds(drillIds);
    }

    /**
     * 删除应急演练信息
     * 
     * @param drillId 应急演练ID
     * @return 结果
     */
    @Override
    public int deleteTEmergencyDrillById(Long drillId)
    {
        return tEmergencyDrillMapper.deleteTEmergencyDrillById(drillId);
    }
}
