package com.zehong.system.service.impl;

import java.text.SimpleDateFormat;
import java.util.*;

import com.sun.org.apache.bcel.internal.generic.NEW;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TDeviceAlarmInfoMapper;
import com.zehong.system.domain.TDeviceAlarmInfo;
import com.zehong.system.service.ITDeviceAlarmInfoService;

/**
 * 报警记录Service业务层处理
 * 
 * @author zehong
 * @date 2022-07-04
 */
@Service
public class TDeviceAlarmInfoServiceImpl implements ITDeviceAlarmInfoService 
{
    @Autowired
    private TDeviceAlarmInfoMapper tDeviceAlarmInfoMapper;

    /**
     * 查询报警记录
     * 
     * @param alarmId 报警记录ID
     * @return 报警记录
     */
    @Override
    public TDeviceAlarmInfo selectTDeviceAlarmInfoById(Long alarmId)
    {
        return tDeviceAlarmInfoMapper.selectTDeviceAlarmInfoById(alarmId);
    }

    /**
     * 查询报警记录列表
     * 
     * @param tDeviceAlarmInfo 报警记录
     * @return 报警记录
     */
    @Override
    public List<TDeviceAlarmInfo> selectTDeviceAlarmInfoList(TDeviceAlarmInfo tDeviceAlarmInfo)
    {
        return tDeviceAlarmInfoMapper.selectTDeviceAlarmInfoList(tDeviceAlarmInfo);
    }

    /**
     * 新增报警记录
     * 
     * @param tDeviceAlarmInfo 报警记录
     * @return 结果
     */
    @Override
    public int insertTDeviceAlarmInfo(TDeviceAlarmInfo tDeviceAlarmInfo)
    {
        tDeviceAlarmInfo.setCreateTime(DateUtils.getNowDate());
        return tDeviceAlarmInfoMapper.insertTDeviceAlarmInfo(tDeviceAlarmInfo);
    }

    /**
     * 修改报警记录
     * 
     * @param tDeviceAlarmInfo 报警记录
     * @return 结果
     */
    @Override
    public int updateTDeviceAlarmInfo(TDeviceAlarmInfo tDeviceAlarmInfo)
    {
        tDeviceAlarmInfo.setUpdateTime(DateUtils.getNowDate());
        return tDeviceAlarmInfoMapper.updateTDeviceAlarmInfo(tDeviceAlarmInfo);
    }

    /**
     * 批量删除报警记录
     * 
     * @param alarmIds 需要删除的报警记录ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceAlarmInfoByIds(Long[] alarmIds)
    {
        return tDeviceAlarmInfoMapper.deleteTDeviceAlarmInfoByIds(alarmIds);
    }

    /**
     * 删除报警记录信息
     * 
     * @param alarmId 报警记录ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceAlarmInfoById(Long alarmId)
    {
        return tDeviceAlarmInfoMapper.deleteTDeviceAlarmInfoById(alarmId);
    }

    /**
     * 报警数据统计
     * @return
     */
    @Override
    public Map<String,Object> selectStatistics()
    {
        Map<String,Object> map = new HashMap<>();
        //根据报警类型划分（30天）
        List<Map<String,Object>> typeList = tDeviceAlarmInfoMapper.selectByType();
        String[] typeLabel = new String[typeList.size()];
        Long[] typeNum =new Long [typeList.size()];
        for(int i=0;i<typeList.size();i++){
            Map<String,Object> m = typeList.get(i);
            typeLabel[i] = (String) m.get("label");
            typeNum[i] =  (Long) m.get("num");
        }
        //根据报警等级划分
        List<Map<String,Object>> levelList = tDeviceAlarmInfoMapper.selectByLevel();
//        String[] levelLabel = new String[levelList.size()];
//        Long[] levelNum =new Long [levelList.size()];
//        for(int i=0;i<levelList.size();i++){
//            Map<String,Object> m = levelList.get(i);
//            levelLabel[i] = (String) m.get("label");
//            levelNum[i] =  (Long) m.get("num");
//        }
        //根据报警状态划分
        List<Map<String,Object>> statusList = tDeviceAlarmInfoMapper.selectByStatus();
        Long processed = 0L;
        Long notProcessed = 0L;
        for(Map<String,Object> m : statusList){
            if(((String)m.get("label")).equals("0")){
                notProcessed += (Long) m.get("num");
            }else {
                processed += (Long) m.get("num");
            }
        }
        //每天报警数量（30天）
        List<Map<String,Object>> everyDayList = tDeviceAlarmInfoMapper.selectEveryDay();
        List<String> datelist = getDays();
        String[] dateLabel = new String[30];
        Long[] dateNum = new Long[]{0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L};
        for(Map<String,Object> m : everyDayList){
            for(int i=0;i<datelist.size();i++){
                dateLabel[i] = datelist.get(i);
                if(((String)m.get("beginTime")).equals(datelist.get(i))){
                    dateNum[i]= (Long) m.get("num");
                }

            }
        }

        map.put("typeLabel",typeLabel);
        map.put("typeNum",typeNum);
        map.put("levelList",levelList);
//        map.put("levelLabel",levelLabel);
//        map.put("levelNum",levelNum);
        map.put("processed",processed);
        map.put("notProcessed",notProcessed);
        map.put("dateLabel",dateLabel);
        map.put("dateNum",dateNum);
        return map;
    }

    public List<String> getDays(){
        List<String> list = new ArrayList<>();
        SimpleDateFormat format = new SimpleDateFormat("MM-dd");
        Date d = new Date();

        //取最后一天日期
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.add(Calendar.DATE, -29);
        list.add(format.format(calendar.getTime()));
        //循环添加
        for(int i= 0;i<29;i++){
            calendar.add(Calendar.DATE, 1);
            list.add(format.format(calendar.getTime()));
        }
        return list;
    }
}
