package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TContractorMapper;
import com.zehong.system.domain.TContractor;
import com.zehong.system.service.ITContractorService;

/**
 * 承包商信息Service业务层处理
 * 
 * @author zehong
 * @date 2022-06-29
 */
@Service
public class TContractorServiceImpl implements ITContractorService 
{
    @Autowired
    private TContractorMapper tContractorMapper;

    /**
     * 查询承包商信息
     * 
     * @param id 承包商信息ID
     * @return 承包商信息
     */
    @Override
    public TContractor selectTContractorById(Long id)
    {
        return tContractorMapper.selectTContractorById(id);
    }

    /**
     * 查询承包商信息列表
     * 
     * @param tContractor 承包商信息
     * @return 承包商信息
     */
    @Override
    public List<TContractor> selectTContractorList(TContractor tContractor)
    {
        return tContractorMapper.selectTContractorList(tContractor);
    }

    /**
     * 新增承包商信息
     * 
     * @param tContractor 承包商信息
     * @return 结果
     */
    @Override
    public int insertTContractor(TContractor tContractor)
    {
        tContractor.setCreateTime(DateUtils.getNowDate());
        return tContractorMapper.insertTContractor(tContractor);
    }

    /**
     * 修改承包商信息
     * 
     * @param tContractor 承包商信息
     * @return 结果
     */
    @Override
    public int updateTContractor(TContractor tContractor)
    {
        tContractor.setUpdateTime(DateUtils.getNowDate());
        return tContractorMapper.updateTContractor(tContractor);
    }

    /**
     * 批量删除承包商信息
     * 
     * @param ids 需要删除的承包商信息ID
     * @return 结果
     */
    @Override
    public int deleteTContractorByIds(Long[] ids)
    {
        return tContractorMapper.deleteTContractorByIds(ids);
    }

    /**
     * 删除承包商信息信息
     * 
     * @param id 承包商信息ID
     * @return 结果
     */
    @Override
    public int deleteTContractorById(Long id)
    {
        return tContractorMapper.deleteTContractorById(id);
    }
}
