package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TTrainPlan;

/**
 * 培训计划Service接口
 * 
 * @author zehong
 * @date 2022-09-17
 */
public interface ITTrainPlanService 
{
    /**
     * 查询培训计划
     * 
     * @param planId 培训计划ID
     * @return 培训计划
     */
    public TTrainPlan selectTTrainPlanById(Long planId);

    /**
     * 查询培训计划列表
     * 
     * @param tTrainPlan 培训计划
     * @return 培训计划集合
     */
    public List<TTrainPlan> selectTTrainPlanList(TTrainPlan tTrainPlan);
    public List<TTrainPlan> selectTTrainPlanDownList();

    /**
     * 新增培训计划
     * 
     * @param tTrainPlan 培训计划
     * @return 结果
     */
    public Long insertTTrainPlan(TTrainPlan tTrainPlan,Long[] postIds);

    /**
     * 修改培训计划
     * 
     * @param tTrainPlan 培训计划
     * @return 结果
     */
    public int updateTTrainPlan(TTrainPlan tTrainPlan,Long[] postIds);

    /**
     * 批量删除培训计划
     * 
     * @param planIds 需要删除的培训计划ID
     * @return 结果
     */
    public int deleteTTrainPlanByIds(Long[] planIds);

    /**
     * 删除培训计划信息
     * 
     * @param planId 培训计划ID
     * @return 结果
     */
    public int deleteTTrainPlanById(Long planId);
}
