package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TStaningBook;

/**
 * 隐患台账Service接口
 * 
 * @author zehong
 * @date 2022-07-09
 */
public interface ITStaningBookService 
{
    /**
     * 查询隐患台账
     * 
     * @param bookId 隐患台账ID
     * @return 隐患台账
     */
    public TStaningBook selectTStaningBookById(Long bookId);

    /**
     * 查询隐患台账列表
     * 
     * @param tStaningBook 隐患台账
     * @return 隐患台账集合
     */
    public List<TStaningBook> selectTStaningBookList(TStaningBook tStaningBook);

    /**
     * 新增隐患台账
     * 
     * @param tStaningBook 隐患台账
     * @return 结果
     */
    public int insertTStaningBook(TStaningBook tStaningBook);

    /**
     * 修改隐患台账
     * 
     * @param tStaningBook 隐患台账
     * @return 结果
     */
    public int updateTStaningBook(TStaningBook tStaningBook);

    /**
     * 批量删除隐患台账
     * 
     * @param bookIds 需要删除的隐患台账ID
     * @return 结果
     */
    public int deleteTStaningBookByIds(Long[] bookIds);

    /**
     * 删除隐患台账信息
     * 
     * @param bookId 隐患台账ID
     * @return 结果
     */
    public int deleteTStaningBookById(Long bookId);
}
