package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TMaintainPlan;
import com.zehong.system.domain.vo.TMaintainPlanVo;

/**
 * 设备保养计划Service接口
 * 
 * @author zehong
 * @date 2022-07-04
 */
public interface ITMaintainPlanService 
{
    /**
     * 查询设备保养计划
     * 
     * @param id 设备保养计划ID
     * @return 设备保养计划
     */
    public TMaintainPlanVo selectTMaintainPlanById(Long id);

    /**
     * 查询设备保养计划列表
     * 
     * @param tMaintainPlan 设备保养计划
     * @return 设备保养计划集合
     */
    public List<TMaintainPlanVo> selectTMaintainPlanList(TMaintainPlan tMaintainPlan);

    /**
     * 新增设备保养计划
     * 
     * @param tMaintainPlan 设备保养计划
     * @return 结果
     */
    public int insertTMaintainPlan(TMaintainPlan tMaintainPlan);

    /**
     * 修改设备保养计划
     * 
     * @param tMaintainPlan 设备保养计划
     * @return 结果
     */
    public int updateTMaintainPlan(TMaintainPlan tMaintainPlan);

    /**
     * 批量删除设备保养计划
     * 
     * @param ids 需要删除的设备保养计划ID
     * @return 结果
     */
    public int deleteTMaintainPlanByIds(Long[] ids);

    /**
     * 删除设备保养计划信息
     * 
     * @param id 设备保养计划ID
     * @return 结果
     */
    public int deleteTMaintainPlanById(Long id);
}
