package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TInspectWorkInfo;

/**
 * 巡检任务信息Service接口
 * 
 * @author zehong
 * @date 2022-06-20
 */
public interface ITInspectWorkInfoService 
{
    /**
     * 查询巡检任务信息
     * 
     * @param workId 巡检任务信息ID
     * @return 巡检任务信息
     */
    public TInspectWorkInfo selectTInspectWorkInfoById(Long workId);

    /**
     * 查询巡检任务信息列表
     * 
     * @param tInspectWorkInfo 巡检任务信息
     * @return 巡检任务信息集合
     */
    public List<TInspectWorkInfo> selectTInspectWorkInfoList(TInspectWorkInfo tInspectWorkInfo);
    public List<TInspectWorkInfo> selectTInspectWorkInfoListChildren(TInspectWorkInfo tInspectWorkInfo);

    /**
     * 个人巡检任务查询
     * @param deptId
     * @return
     */
    public List<TInspectWorkInfo> taskList(Long deptId);

    /**
     * 新增巡检任务信息
     * 
     * @param tInspectWorkInfo 巡检任务信息
     * @return 结果
     */
    public int insertTInspectWorkInfo(TInspectWorkInfo tInspectWorkInfo);

    /**
     * 修改巡检任务信息
     * 
     * @param tInspectWorkInfo 巡检任务信息
     * @return 结果
     */
    public int updateTInspectWorkInfo(TInspectWorkInfo tInspectWorkInfo);

    /**
     * 批量删除巡检任务信息
     * 
     * @param workIds 需要删除的巡检任务信息ID
     * @return 结果
     */
    public int deleteTInspectWorkInfoByIds(Long[] workIds);

    /**
     * 删除巡检任务信息信息
     * 
     * @param workId 巡检任务信息ID
     * @return 结果
     */
    public int deleteTInspectWorkInfoById(Long workId);

    /**
     * 定时发布任务
     */
    public void implementTiming();
}
