package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.THiddenTroubleWork;

/**
 * 隐患排查任务Service接口
 * 
 * @author zehong
 * @date 2022-07-11
 */
public interface ITHiddenTroubleWorkService 
{
    /**
     * 查询隐患排查任务
     * 
     * @param workId 隐患排查任务ID
     * @return 隐患排查任务
     */
    public THiddenTroubleWork selectTHiddenTroubleWorkById(Long workId);

    /**
     * 查询隐患排查任务列表
     * 
     * @param tHiddenTroubleWork 隐患排查任务
     * @return 隐患排查任务集合
     */
    public List<THiddenTroubleWork> selectTHiddenTroubleWorkList(THiddenTroubleWork tHiddenTroubleWork);

    /**
     * 新增隐患排查任务
     * 
     * @param tHiddenTroubleWork 隐患排查任务
     * @return 结果
     */
    public int insertTHiddenTroubleWork(THiddenTroubleWork tHiddenTroubleWork);

    /**
     * 修改隐患排查任务
     * 
     * @param tHiddenTroubleWork 隐患排查任务
     * @return 结果
     */
    public int updateTHiddenTroubleWork(THiddenTroubleWork tHiddenTroubleWork);

    /**
     * 批量删除隐患排查任务
     * 
     * @param workIds 需要删除的隐患排查任务ID
     * @return 结果
     */
    public int deleteTHiddenTroubleWorkByIds(Long[] workIds);

    /**
     * 删除隐患排查任务信息
     * 
     * @param workId 隐患排查任务ID
     * @return 结果
     */
    public int deleteTHiddenTroubleWorkById(Long workId);

    /**
     * 定时任务
     */
    public void hiddenTroubleWorkTiming();
}
