package com.zehong.system.service;


import com.zehong.system.domain.TEnterpriseSystem;

import java.util.List;

/**
 * 企业制度管理Service接口
 * 
 * @author zehong
 * @date 2022-06-21
 */
public interface ITEnterpriseSystemService 
{
    /**
     * 查询企业制度管理
     * 
     * @param systemId 企业制度管理ID
     * @return 企业制度管理
     */
    public TEnterpriseSystem selectTEnterpriseSystemById(Long systemId);

    /**
     * 查询企业制度管理列表
     * 
     * @param tEnterpriseSystem 企业制度管理
     * @return 企业制度管理集合
     */
    public List<TEnterpriseSystem> selectTEnterpriseSystemList(TEnterpriseSystem tEnterpriseSystem);

    /**
     * 新增企业制度管理
     * 
     * @param tEnterpriseSystem 企业制度管理
     * @return 结果
     */
    public int insertTEnterpriseSystem(TEnterpriseSystem tEnterpriseSystem);

    /**
     * 修改企业制度管理
     * 
     * @param tEnterpriseSystem 企业制度管理
     * @return 结果
     */
    public int updateTEnterpriseSystem(TEnterpriseSystem tEnterpriseSystem);

    /**
     * 批量删除企业制度管理
     * 
     * @param systemIds 需要删除的企业制度管理ID
     * @return 结果
     */
    public int deleteTEnterpriseSystemByIds(Long[] systemIds);

    /**
     * 删除企业制度管理信息
     * 
     * @param systemId 企业制度管理ID
     * @return 结果
     */
    public int deleteTEnterpriseSystemById(Long systemId);
}
