package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TEnterpriseCertificate;

/**
 * 企业资质证照管理Service接口
 * 
 * @author zehong
 * @date 2022-06-23
 */
public interface ITEnterpriseCertificateService 
{
    /**
     * 查询企业资质证照管理
     * 
     * @param id 企业资质证照管理ID
     * @return 企业资质证照管理
     */
    public TEnterpriseCertificate selectTEnterpriseCertificateById(Long id);

    /**
     * 查询企业资质证照管理列表
     * 
     * @param tEnterpriseCertificate 企业资质证照管理
     * @return 企业资质证照管理集合
     */
    public List<TEnterpriseCertificate> selectTEnterpriseCertificateList(TEnterpriseCertificate tEnterpriseCertificate);

    /**
     * 新增企业资质证照管理
     * 
     * @param tEnterpriseCertificate 企业资质证照管理
     * @return 结果
     */
    public int insertTEnterpriseCertificate(TEnterpriseCertificate tEnterpriseCertificate);

    /**
     * 修改企业资质证照管理
     * 
     * @param tEnterpriseCertificate 企业资质证照管理
     * @return 结果
     */
    public int updateTEnterpriseCertificate(TEnterpriseCertificate tEnterpriseCertificate);

    /**
     * 批量删除企业资质证照管理
     * 
     * @param ids 需要删除的企业资质证照管理ID
     * @return 结果
     */
    public int deleteTEnterpriseCertificateByIds(Long[] ids);

    /**
     * 删除企业资质证照管理信息
     * 
     * @param id 企业资质证照管理ID
     * @return 结果
     */
    public int deleteTEnterpriseCertificateById(Long id);
}
