package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TEmergencyDrill;

/**
 * 应急演练Service接口
 * 
 * @author zehong
 * @date 2022-06-29
 */
public interface ITEmergencyDrillService 
{
    /**
     * 查询应急演练
     * 
     * @param drillId 应急演练ID
     * @return 应急演练
     */
    public TEmergencyDrill selectTEmergencyDrillById(Long drillId);

    /**
     * 查询应急演练列表
     * 
     * @param tEmergencyDrill 应急演练
     * @return 应急演练集合
     */
    public List<TEmergencyDrill> selectTEmergencyDrillList(TEmergencyDrill tEmergencyDrill);

    /**
     * 新增应急演练
     * 
     * @param tEmergencyDrill 应急演练
     * @return 结果
     */
    public int insertTEmergencyDrill(TEmergencyDrill tEmergencyDrill);

    /**
     * 修改应急演练
     * 
     * @param tEmergencyDrill 应急演练
     * @return 结果
     */
    public int updateTEmergencyDrill(TEmergencyDrill tEmergencyDrill);

    /**
     * 批量删除应急演练
     * 
     * @param drillIds 需要删除的应急演练ID
     * @return 结果
     */
    public int deleteTEmergencyDrillByIds(Long[] drillIds);

    /**
     * 删除应急演练信息
     * 
     * @param drillId 应急演练ID
     * @return 结果
     */
    public int deleteTEmergencyDrillById(Long drillId);
}
