package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TDeviceInfo;

/**
 * 设备信息管理Service接口
 * 
 * @author zehong
 * @date 2022-07-02
 */
public interface ITDeviceInfoService 
{
    /**
     * 查询设备信息管理
     * 
     * @param id 设备信息管理ID
     * @return 设备信息管理
     */
    public TDeviceInfo selectTDeviceInfoById(Long id);

    /**
     * 查询设备信息管理列表
     * 
     * @param tDeviceInfo 设备信息管理
     * @return 设备信息管理集合
     */
    public List<TDeviceInfo> selectTDeviceInfoList(TDeviceInfo tDeviceInfo);

    /**
     * 新增设备信息管理
     * 
     * @param tDeviceInfo 设备信息管理
     * @return 结果
     */
    public int insertTDeviceInfo(TDeviceInfo tDeviceInfo);

    /**
     * 修改设备信息管理
     * 
     * @param tDeviceInfo 设备信息管理
     * @return 结果
     */
    public int updateTDeviceInfo(TDeviceInfo tDeviceInfo);

    /**
     * 批量删除设备信息管理
     * 
     * @param ids 需要删除的设备信息管理ID
     * @return 结果
     */
    public int deleteTDeviceInfoByIds(Long[] ids);

    /**
     * 删除设备信息管理信息
     * 
     * @param id 设备信息管理ID
     * @return 结果
     */
    public int deleteTDeviceInfoById(Long id);

    /**
     * 导入设备数据
     *
     * @param TDeviceInfo 用户数据列表
     * @param isUpdateSupport 是否更新支持，如果已存在，则进行更新数据
     * @param
     * @return 结果
     */
    public String importDevice(List<TDeviceInfo> TDeviceInfo, Boolean isUpdateSupport);
}
