package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TWorkPermit;

/**
 * 作业许可证Mapper接口
 * 
 * @author zehong
 * @date 2022-08-18
 */
public interface TWorkPermitMapper 
{
    /**
     * 查询作业许可证
     * 
     * @param workPermitId 作业许可证ID
     * @return 作业许可证
     */
    public TWorkPermit selectTWorkPermitById(Long workPermitId);

    /**
     * 查询作业许可证列表
     * 
     * @param tWorkPermit 作业许可证
     * @return 作业许可证集合
     */
    public List<TWorkPermit> selectTWorkPermitList(TWorkPermit tWorkPermit);

    /**
     * 新增作业许可证
     * 
     * @param tWorkPermit 作业许可证
     * @return 结果
     */
    public int insertTWorkPermit(TWorkPermit tWorkPermit);

    /**
     * 修改作业许可证
     * 
     * @param tWorkPermit 作业许可证
     * @return 结果
     */
    public int updateTWorkPermit(TWorkPermit tWorkPermit);

    /**
     * 删除作业许可证
     * 
     * @param workPermitId 作业许可证ID
     * @return 结果
     */
    public int deleteTWorkPermitById(Long workPermitId);

    /**
     * 批量删除作业许可证
     * 
     * @param workPermitIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTWorkPermitByIds(Long[] workPermitIds);
}
