package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TTrainUserCourse;

/**
 * 用户课程Mapper接口
 * 
 * @author zehong
 * @date 2022-09-19
 */
public interface TTrainUserCourseMapper 
{
    /**
     * 查询用户课程
     * 
     * @param userCourseId 用户课程ID
     * @return 用户课程
     */
    public TTrainUserCourse selectTTrainUserCourseById(Long userCourseId);

    /**
     * 查询用户课程列表
     * 
     * @param tTrainUserCourse 用户课程
     * @return 用户课程集合
     */
    public List<TTrainUserCourse> selectTTrainUserCourseList(TTrainUserCourse tTrainUserCourse);

    /**
     * 新增用户课程
     * 
     * @param tTrainUserCourse 用户课程
     * @return 结果
     */
    public int insertTTrainUserCourse(TTrainUserCourse tTrainUserCourse);

    /**
     * 修改用户课程
     * 
     * @param tTrainUserCourse 用户课程
     * @return 结果
     */
    public int updateTTrainUserCourse(TTrainUserCourse tTrainUserCourse);

    /**
     * 删除用户课程
     * 
     * @param userCourseId 用户课程ID
     * @return 结果
     */
    public int deleteTTrainUserCourseById(Long userCourseId);

    /**
     * 批量删除用户课程
     * 
     * @param userCourseIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTTrainUserCourseByIds(Long[] userCourseIds);
}
