package com.zehong.system.mapper;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TTrainPlan;
import com.zehong.system.domain.vo.PlanPostVo;
import org.apache.ibatis.annotations.Param;

/**
 * 培训计划Mapper接口
 * 
 * @author zehong
 * @date 2022-09-17
 */
public interface TTrainPlanMapper 
{
    /**
     * 查询培训计划
     * 
     * @param planId 培训计划ID
     * @return 培训计划
     */
    public TTrainPlan selectTTrainPlanById(Long planId);

    /**
     * 查询培训计划列表
     * 
     * @param tTrainPlan 培训计划
     * @return 培训计划集合
     */
    public List<TTrainPlan> selectTTrainPlanList(TTrainPlan tTrainPlan);

    /**
     * 查询培训计划包含的岗位信息
     * @param planId
     * @return
     */
    public List<PlanPostVo> selectTrainPostByPlanId(Long planId);

    /**
     * 新增培训计划
     * 
     * @param tTrainPlan 培训计划
     * @return 结果
     */
    public int insertTTrainPlan(TTrainPlan tTrainPlan);

    /**
     * 批量添加 培训计划
     * @param planId
     * @param postIds
     * @return
     */
    public int insetsPlanPost(@Param("planId") Long planId, @Param("postIds")Long[] postIds);

    /**
     * 删除计划职位
     * @param planId
     * @return
     */
    public int deletePlanPost(@Param("planId") Long planId);

    /**
     * 修改培训计划
     * 
     * @param tTrainPlan 培训计划
     * @return 结果
     */
    public int updateTTrainPlan(TTrainPlan tTrainPlan);

    /**
     * 删除培训计划
     * 
     * @param planId 培训计划ID
     * @return 结果
     */
    public int deleteTTrainPlanById(Long planId);

    /**
     * 批量删除培训计划
     * 
     * @param planIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTTrainPlanByIds(Long[] planIds);

    /**
     * 查询该计划涉及所有人id
     * @param planId
     * @return
     */
    public List<String> selectAlluserByplanId(Long planId);
}
