package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TTrainCourseTopic;
import org.apache.ibatis.annotations.Param;

/**
 * 培训课程题库Mapper接口
 * 
 * @author zehong
 * @date 2022-09-19
 */
public interface TTrainCourseTopicMapper 
{
    /**
     * 查询培训课程题库
     * 
     * @param topicId 培训课程题库ID
     * @return 培训课程题库
     */
    public TTrainCourseTopic selectTTrainCourseTopicById(Long topicId);

    /**
     * 查询培训课程题库列表
     * 
     * @param tTrainCourseTopic 培训课程题库
     * @return 培训课程题库集合
     */
    public List<TTrainCourseTopic> selectTTrainCourseTopicList(TTrainCourseTopic tTrainCourseTopic);
    public List<TTrainCourseTopic> selectCourseTopicList(@Param("courseId") Long courseId);

    /**
     * 新增培训课程题库
     * 
     * @param tTrainCourseTopic 培训课程题库
     * @return 结果
     */
    public int insertTTrainCourseTopic(TTrainCourseTopic tTrainCourseTopic);

    /**
     * 修改培训课程题库
     * 
     * @param tTrainCourseTopic 培训课程题库
     * @return 结果
     */
    public int updateTTrainCourseTopic(TTrainCourseTopic tTrainCourseTopic);

    /**
     * 删除培训课程题库
     * 
     * @param topicId 培训课程题库ID
     * @return 结果
     */
    public int deleteTTrainCourseTopicById(Long topicId);

    /**
     * 批量删除培训课程题库
     * 
     * @param topicIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTTrainCourseTopicByIds(Long[] topicIds);
}
