package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TStaff;
import com.zehong.system.domain.form.TStaffForm;
import com.zehong.system.domain.vo.TStaffVo;

/**
 * 员工信息管理Mapper接口
 * 
 * @author zehong
 * @date 2022-06-17
 */
public interface TStaffMapper 
{
    /**
     * 获取员工编号
     *
     * @return 员工编号
     */
    public String getStaffCode();

    /**
     * 查询员工信息管理
     * 
     * @param staffId 员工信息管理ID
     * @return 员工信息管理
     */
    public TStaffVo selectTStaffById(Long staffId);

    /**
     * 查询员工信息管理列表
     * 
     * @param tStaff 员工信息管理
     * @return 员工信息管理集合
     */
    public List<TStaffVo> selectTStaffList(TStaffForm tStaff);

    /**
     * 新增员工信息管理
     * 
     * @param tStaff 员工信息管理
     * @return 结果
     */
    public int insertTStaff(TStaff tStaff);

    /**
     * 修改员工信息管理
     * 
     * @param tStaff 员工信息管理
     * @return 结果
     */
    public int updateTStaff(TStaff tStaff);

    /**
     * 删除员工信息管理
     * 
     * @param staffId 员工信息管理ID
     * @return 结果
     */
    public int deleteTStaffById(Long staffId);

    /**
     * 批量删除员工信息管理
     * 
     * @param staffIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTStaffByIds(Long[] staffIds);
}
