package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TSpecialWorkPermit;

/**
 * 特殊作业许可证Mapper接口
 * 
 * @author zehong
 * @date 2022-08-25
 */
public interface TSpecialWorkPermitMapper 
{
    /**
     * 查询特殊作业许可证
     * 
     * @param specialWorkPermitId 特殊作业许可证ID
     * @return 特殊作业许可证
     */
    public TSpecialWorkPermit selectTSpecialWorkPermitById(Long specialWorkPermitId);

    /**
     * 查询特殊作业许可证列表
     * 
     * @param tSpecialWorkPermit 特殊作业许可证
     * @return 特殊作业许可证集合
     */
    public List<TSpecialWorkPermit> selectTSpecialWorkPermitList(TSpecialWorkPermit tSpecialWorkPermit);

    /**
     * 新增特殊作业许可证
     * 
     * @param tSpecialWorkPermit 特殊作业许可证
     * @return 结果
     */
    public int insertTSpecialWorkPermit(TSpecialWorkPermit tSpecialWorkPermit);

    /**
     * 修改特殊作业许可证
     * 
     * @param tSpecialWorkPermit 特殊作业许可证
     * @return 结果
     */
    public int updateTSpecialWorkPermit(TSpecialWorkPermit tSpecialWorkPermit);

    /**
     * 删除特殊作业许可证
     * 
     * @param specialWorkPermitId 特殊作业许可证ID
     * @return 结果
     */
    public int deleteTSpecialWorkPermitById(Long specialWorkPermitId);

    /**
     * 批量删除特殊作业许可证
     * 
     * @param specialWorkPermitIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTSpecialWorkPermitByIds(Long[] specialWorkPermitIds);
}
