package com.zehong.system.mapper;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TPatrolPosition;

/**
 * 巡检点Mapper接口
 * 
 * @author zehong
 * @date 2022-06-17
 */
public interface TPatrolPositionMapper 
{
    /**
     * 查询巡检点
     * 
     * @param patrolId 巡检点ID
     * @return 巡检点
     */
    public TPatrolPosition selectTPatrolPositionById(Long patrolId);

    /**
     * 查询巡检点列表
     * 
     * @param tPatrolPosition 巡检点
     * @return 巡检点集合
     */
    public List<TPatrolPosition> selectTPatrolPositionList(TPatrolPosition tPatrolPosition);

    /**
     * 新增巡检点
     * 
     * @param tPatrolPosition 巡检点
     * @return 结果
     */
    public int insertTPatrolPosition(TPatrolPosition tPatrolPosition);

    /**
     * 修改巡检点
     * 
     * @param tPatrolPosition 巡检点
     * @return 结果
     */
    public int updateTPatrolPosition(TPatrolPosition tPatrolPosition);

    /**
     * 删除巡检点
     * 
     * @param patrolId 巡检点ID
     * @return 结果
     */
    public int deleteTPatrolPositionById(Long patrolId);

    /**
     * 批量删除巡检点
     * 
     * @param patrolIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTPatrolPositionByIds(Long[] patrolIds);

    /**
     * 巡检点树
     * @return
     */
    public List<Map<String,Object>> selectPositionBy(long deptId);
}
