package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TInvestment;

/**
 * 投入台账Mapper接口
 * 
 * @author zehong
 * @date 2022-06-24
 */
public interface TInvestmentMapper 
{
    /**
     * 查询投入台账
     * 
     * @param id 投入台账ID
     * @return 投入台账
     */
    public TInvestment selectTInvestmentById(Long id);

    /**
     * 查询投入台账列表
     * 
     * @param tInvestment 投入台账
     * @return 投入台账集合
     */
    public List<TInvestment> selectTInvestmentList(TInvestment tInvestment);

    /**
     * 新增投入台账
     * 
     * @param tInvestment 投入台账
     * @return 结果
     */
    public int insertTInvestment(TInvestment tInvestment);

    /**
     * 修改投入台账
     * 
     * @param tInvestment 投入台账
     * @return 结果
     */
    public int updateTInvestment(TInvestment tInvestment);

    /**
     * 删除投入台账
     * 
     * @param id 投入台账ID
     * @return 结果
     */
    public int deleteTInvestmentById(Long id);

    /**
     * 批量删除投入台账
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTInvestmentByIds(Long[] ids);
}
