package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.THiddenLibrary;

/**
 * 隐患排查库Mapper接口
 * 
 * @author zehong
 * @date 2022-07-13
 */
public interface THiddenLibraryMapper 
{
    /**
     * 查询隐患排查库
     * 
     * @param libraryId 隐患排查库ID
     * @return 隐患排查库
     */
    public THiddenLibrary selectTHiddenLibraryById(Long libraryId);

    /**
     * 查询隐患排查库列表
     * 
     * @param tHiddenLibrary 隐患排查库
     * @return 隐患排查库集合
     */
    public List<THiddenLibrary> selectTHiddenLibraryList(THiddenLibrary tHiddenLibrary);

    /**
     * 新增隐患排查库
     * 
     * @param tHiddenLibrary 隐患排查库
     * @return 结果
     */
    public int insertTHiddenLibrary(THiddenLibrary tHiddenLibrary);

    /**
     * 修改隐患排查库
     * 
     * @param tHiddenLibrary 隐患排查库
     * @return 结果
     */
    public int updateTHiddenLibrary(THiddenLibrary tHiddenLibrary);

    /**
     * 删除隐患排查库
     * 
     * @param libraryId 隐患排查库ID
     * @return 结果
     */
    public int deleteTHiddenLibraryById(Long libraryId);

    /**
     * 批量删除隐患排查库
     * 
     * @param libraryIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTHiddenLibraryByIds(Long[] libraryIds);
}
