package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TEnterpriseSystem;

/**
 * 企业制度管理Mapper接口
 * 
 * @author zehong
 * @date 2022-06-21
 */
public interface TEnterpriseSystemMapper 
{
    /**
     * 查询企业制度管理
     * 
     * @param systemId 企业制度管理ID
     * @return 企业制度管理
     */
    public TEnterpriseSystem selectTEnterpriseSystemById(Long systemId);

    /**
     * 查询企业制度管理列表
     * 
     * @param tEnterpriseSystem 企业制度管理
     * @return 企业制度管理集合
     */
    public List<TEnterpriseSystem> selectTEnterpriseSystemList(TEnterpriseSystem tEnterpriseSystem);

    /**
     * 新增企业制度管理
     * 
     * @param tEnterpriseSystem 企业制度管理
     * @return 结果
     */
    public int insertTEnterpriseSystem(TEnterpriseSystem tEnterpriseSystem);

    /**
     * 修改企业制度管理
     * 
     * @param tEnterpriseSystem 企业制度管理
     * @return 结果
     */
    public int updateTEnterpriseSystem(TEnterpriseSystem tEnterpriseSystem);

    /**
     * 删除企业制度管理
     * 
     * @param systemId 企业制度管理ID
     * @return 结果
     */
    public int deleteTEnterpriseSystemById(Long systemId);

    /**
     * 批量删除企业制度管理
     * 
     * @param systemIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTEnterpriseSystemByIds(Long[] systemIds);
}
