package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TEnterpriseInfo;

/**
 * 企业基础信息管理Mapper接口
 * 
 * @author zehong
 * @date 2022-06-23
 */
public interface TEnterpriseInfoMapper 
{
    /**
     * 查询企业基础信息管理
     * 
     * @param id 企业基础信息管理ID
     * @return 企业基础信息管理
     */
    public TEnterpriseInfo selectTEnterpriseInfoById(Long id);

    /**
     * 查询企业基础信息管理列表
     * 
     * @param tEnterpriseInfo 企业基础信息管理
     * @return 企业基础信息管理集合
     */
    public List<TEnterpriseInfo> selectTEnterpriseInfoList(TEnterpriseInfo tEnterpriseInfo);

    /**
     * 新增企业基础信息管理
     * 
     * @param tEnterpriseInfo 企业基础信息管理
     * @return 结果
     */
    public int insertTEnterpriseInfo(TEnterpriseInfo tEnterpriseInfo);

    /**
     * 修改企业基础信息管理
     * 
     * @param tEnterpriseInfo 企业基础信息管理
     * @return 结果
     */
    public int updateTEnterpriseInfo(TEnterpriseInfo tEnterpriseInfo);

    /**
     * 删除企业基础信息管理
     * 
     * @param id 企业基础信息管理ID
     * @return 结果
     */
    public int deleteTEnterpriseInfoById(Long id);

    /**
     * 批量删除企业基础信息管理
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTEnterpriseInfoByIds(Long[] ids);
}
