package com.zehong.system.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.DataSource;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;

/**
 * 员工信息管理对象 t_staff
 * 
 * @author zehong
 * @date 2022-06-17
 */
@Data
public class TStaffVo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 员工id */
    private Integer staffId;

    /** 姓名 */
    private String staffName;

    /** 员工编号 */
    private String staffCode;

    /** 性别 */
    private String sex;

    /** 部门id */
    private Integer deptId;

    private String deptName;

    /** 手机号码 */
    private String phonenumber;

    /** 岗位id */
    private Integer postId;

    private String postName;

    /** 角色id */
    private Integer roleId;

    private String roleName;

    /** 职称 */
    private String positionalTitles;

    /** 工种 */
    private String profession;

    /** 是否特殊作业人员 */
    private String specialOperators;

    /** 证书路径 */
    private String certificateUrl;

    /** 证书名称 */
    private String certificateName;

    /** 证书有效日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date effectiveDate;

    /** 删除标志（0正常，1删除） */
    private String isDel;

}
