package com.zehong.system.domain;

import com.zehong.system.domain.vo.PlanPostVo;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.util.List;
import java.util.Map;

/**
 * 培训计划对象 t_train_plan
 * 
 * @author zehong
 * @date 2022-09-17
 */
public class TTrainPlan extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long planId;

    /** 计划名称 */
    @Excel(name = "计划名称")
    private String planName;

    /** 排序 */
    @Excel(name = "排序")
    private Integer sort;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createUser;


    private List<PlanPostVo> postList;

    public List<PlanPostVo> getPostList() {
        return postList;
    }

    public void setPostList(List<PlanPostVo> postList) {
        this.postList = postList;
    }

    public void setPlanId(Long planId)
    {
        this.planId = planId;
    }

    public Long getPlanId() 
    {
        return planId;
    }
    public void setPlanName(String planName) 
    {
        this.planName = planName;
    }

    public String getPlanName() 
    {
        return planName;
    }
    public void setSort(Integer sort) 
    {
        this.sort = sort;
    }

    public Integer getSort() 
    {
        return sort;
    }
    public void setCreateUser(String createUser) 
    {
        this.createUser = createUser;
    }

    public String getCreateUser() 
    {
        return createUser;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("planId", getPlanId())
            .append("planName", getPlanName())
            .append("sort", getSort())
            .append("createTime", getCreateTime())
            .append("createUser", getCreateUser())
            .toString();
    }
}
