package com.zehong.system.domain;

import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 培训课程题库对象 t_train_course_topic
 * 
 * @author zehong
 * @date 2022-09-19
 */
public class TTrainCourseTopic extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 题目id */
    private Long topicId;

    /** 所属课程id */
    @Excel(name = "所属课程id")
    private Long courseId;

    /** 题目内容 */
    @Excel(name = "题目内容")
    private String topicTitle;

    /** 题目选项（json） */
    @Excel(name = "题目选项", readConverterExp = "j=son")
    private String topicOption;

    /** 答案 */
    @Excel(name = "答案")
    private Integer answer;

    public void setTopicId(Long topicId) 
    {
        this.topicId = topicId;
    }

    public Long getTopicId() 
    {
        return topicId;
    }
    public void setCourseId(Long courseId) 
    {
        this.courseId = courseId;
    }

    public Long getCourseId() 
    {
        return courseId;
    }
    public void setTopicTitle(String topicTitle) 
    {
        this.topicTitle = topicTitle;
    }

    public String getTopicTitle() 
    {
        return topicTitle;
    }
    public void setTopicOption(String topicOption) 
    {
        this.topicOption = topicOption;
    }

    public String getTopicOption() 
    {
        return topicOption;
    }
    public void setAnswer(Integer answer) 
    {
        this.answer = answer;
    }

    public Integer getAnswer() 
    {
        return answer;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("topicId", getTopicId())
            .append("courseId", getCourseId())
            .append("topicTitle", getTopicTitle())
            .append("topicOption", getTopicOption())
            .append("answer", getAnswer())
            .append("createTime", getCreateTime())
            .toString();
    }
}
