package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 员工信息管理对象 t_staff
 * 
 * @author zehong
 * @date 2022-06-17
 */
public class TStaff extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 员工id */
    private Integer staffId;

    /** 姓名 */
    @Excel(name = "姓名")
    private String staffName;

    /** 员工编号 */
    @Excel(name = "员工编号")
    private String staffCode;

    /** 性别 */
    @Excel(name = "性别")
    private String sex;

    /** 部门id */
    @Excel(name = "部门id")
    private Integer deptId;

    /** 手机号码 */
    @Excel(name = "手机号码")
    private String phonenumber;

    /** 岗位id */
    @Excel(name = "岗位id")
    private Integer postId;

    /** 角色id */
    @Excel(name = "角色id")
    private Integer roleId;

    /** 职称 */
    @Excel(name = "职称")
    private String positionalTitles;

    /** 工种 */
    @Excel(name = "工种")
    private String profession;

    /** 是否特殊作业人员 */
    @Excel(name = "是否特殊作业人员")
    private String specialOperators;

    /** 证书路径 */
    @Excel(name = "证书路径")
    private String certificateUrl;

    /** 证书名称 */
    @Excel(name = "证书名称")
    private String certificateName;

    /** 证书有效日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "证书有效日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date effectiveDate;

    /** 删除标志（0正常，1删除） */
    @Excel(name = "删除标志", readConverterExp = "0=正常，1删除")
    private String isDel;

    public void setStaffId(int staffId)
    {
        this.staffId = staffId;
    }

    public int getStaffId()
    {
        return staffId;
    }
    public void setStaffName(String staffName) 
    {
        this.staffName = staffName;
    }

    public String getStaffName() 
    {
        return staffName;
    }
    public void setStaffCode(String staffCode) 
    {
        this.staffCode = staffCode;
    }

    public String getStaffCode() 
    {
        return staffCode;
    }
    public void setSex(String sex) 
    {
        this.sex = sex;
    }

    public String getSex() 
    {
        return sex;
    }
    public void setDeptId(Integer deptId)
    {
        this.deptId = deptId;
    }

    public Integer getDeptId()
    {
        return deptId;
    }
    public void setPhonenumber(String phonenumber) 
    {
        this.phonenumber = phonenumber;
    }

    public String getPhonenumber() 
    {
        return phonenumber;
    }
    public void setPostId(Integer postId)
    {
        this.postId = postId;
    }

    public Integer getPostId()
    {
        return postId;
    }
    public void setRoleId(Integer roleId)
    {
        this.roleId = roleId;
    }

    public Integer getRoleId()
    {
        return roleId;
    }
    public void setPositionalTitles(String positionalTitles) 
    {
        this.positionalTitles = positionalTitles;
    }

    public String getPositionalTitles() 
    {
        return positionalTitles;
    }
    public void setProfession(String profession) 
    {
        this.profession = profession;
    }

    public String getProfession() 
    {
        return profession;
    }
    public void setSpecialOperators(String specialOperators) 
    {
        this.specialOperators = specialOperators;
    }

    public String getSpecialOperators() 
    {
        return specialOperators;
    }
    public void setCertificateUrl(String certificateUrl) 
    {
        this.certificateUrl = certificateUrl;
    }

    public String getCertificateUrl() 
    {
        return certificateUrl;
    }
    public void setCertificateName(String certificateName) 
    {
        this.certificateName = certificateName;
    }

    public String getCertificateName() 
    {
        return certificateName;
    }
    public void setEffectiveDate(Date effectiveDate) 
    {
        this.effectiveDate = effectiveDate;
    }

    public Date getEffectiveDate() 
    {
        return effectiveDate;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("staffId", getStaffId())
            .append("staffName", getStaffName())
            .append("staffCode", getStaffCode())
            .append("sex", getSex())
            .append("deptId", getDeptId())
            .append("phonenumber", getPhonenumber())
            .append("postId", getPostId())
            .append("roleId", getRoleId())
            .append("positionalTitles", getPositionalTitles())
            .append("profession", getProfession())
            .append("specialOperators", getSpecialOperators())
            .append("certificateUrl", getCertificateUrl())
            .append("certificateName", getCertificateName())
            .append("effectiveDate", getEffectiveDate())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .append("isDel", getIsDel())
            .toString();
    }
}
