package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 设备维修工单对象 t_repair_order
 * 
 * @author zehong
 * @date 2022-07-04
 */
public class TRepairOrder extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 工单名称 */
    @Excel(name = "工单名称")
    private String repairName;

    /** 工单编号 */
    @Excel(name = "工单编号")
    private String repairCode;

    /** 设备id */
    @Excel(name = "设备id")
    private Long deviceId;

    /** 故障描述 */
    @Excel(name = "故障描述")
    private String troubleDescribe;

    /** 上传照片路径 */
    @Excel(name = "上传照片路径")
    private String fileUrl;

    /** 工单状态 */
    @Excel(name = "工单状态")
    private String orderStatus;

    /** 是否删除（0正常，1删除） */
    @Excel(name = "是否删除", readConverterExp = "0=正常，1=删除")
    private String isDel;

    /** 备注信息 */
    @Excel(name = "备注信息")
    private String remarks;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setRepairName(String repairName) 
    {
        this.repairName = repairName;
    }

    public String getRepairName() 
    {
        return repairName;
    }
    public void setRepairCode(String repairCode) 
    {
        this.repairCode = repairCode;
    }

    public String getRepairCode()
    {
        return repairCode;
    }
    public void setDeviceId(Long deviceId)
    {
        this.deviceId = deviceId;
    }

    public Long getDeviceId()
    {
        return deviceId;
    }
    public void setTroubleDescribe(String troubleDescribe) 
    {
        this.troubleDescribe = troubleDescribe;
    }

    public String getTroubleDescribe() 
    {
        return troubleDescribe;
    }
    public void setFileUrl(String fileUrl) 
    {
        this.fileUrl = fileUrl;
    }

    public String getFileUrl() 
    {
        return fileUrl;
    }
    public void setOrderStatus(String orderStatus) 
    {
        this.orderStatus = orderStatus;
    }

    public String getOrderStatus() 
    {
        return orderStatus;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("repairName", getRepairName())
            .append("repairCode", getRepairCode())
            .append("deviceId", getDeviceId())
            .append("troubleDescribe", getTroubleDescribe())
            .append("fileUrl", getFileUrl())
            .append("orderStatus", getOrderStatus())
            .append("isDel", getIsDel())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
