package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 巡检点对象 t_patrol_position
 * 
 * @author zehong
 * @date 2022-06-17
 */
public class TPatrolPosition extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 巡检点id */
    private Long patrolId;

    /** 巡检点名称 */
    @Excel(name = "巡检点名称")
    private String patrolName;

    /** 巡检点类型 */
    @Excel(name = "巡检点类型")
    private Integer patrolType;

    /** 关联nfc */
    @Excel(name = "关联nfc")
    private String patrolNfc;

    /** 巡检点位置 */
    @Excel(name = "巡检点位置")
    private String position;

    /** 巡检点参数 */
    @Excel(name = "巡检点参数")
    private String patrolDetail;

    /** 部门id */
    @Excel(name = "部门id")
    private Long deptId;
    @Excel(name = "部门名称")
    private String  deptName;
    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    private Integer isDel;

    public Integer getIsDel() {
        return isDel;
    }

    public void setIsDel(Integer isDel) {
        this.isDel = isDel;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public void setPatrolId(Long patrolId)
    {
        this.patrolId = patrolId;
    }

    public Long getPatrolId() 
    {
        return patrolId;
    }
    public void setPatrolName(String patrolName) 
    {
        this.patrolName = patrolName;
    }

    public String getPatrolName() 
    {
        return patrolName;
    }
    public void setPatrolType(Integer patrolType) 
    {
        this.patrolType = patrolType;
    }

    public Integer getPatrolType() 
    {
        return patrolType;
    }
    public void setPatrolNfc(String patrolNfc) 
    {
        this.patrolNfc = patrolNfc;
    }

    public String getPatrolNfc() 
    {
        return patrolNfc;
    }
    public void setPosition(String position) 
    {
        this.position = position;
    }

    public String getPosition() 
    {
        return position;
    }
    public void setPatrolDetail(String patrolDetail) 
    {
        this.patrolDetail = patrolDetail;
    }

    public String getPatrolDetail() 
    {
        return patrolDetail;
    }
    public void setDeptId(Long deptId) 
    {
        this.deptId = deptId;
    }

    public Long getDeptId() 
    {
        return deptId;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("patrolId", getPatrolId())
            .append("patrolName", getPatrolName())
            .append("patrolType", getPatrolType())
            .append("patrolNfc", getPatrolNfc())
            .append("position", getPosition())
            .append("patrolDetail", getPatrolDetail())
            .append("deptId", getDeptId())
            .append("remarks", getRemarks())
            .append("createTime", getCreateTime())
            .append("createBy", getCreateBy())
            .append("updateTime", getUpdateTime())
            .append("updateBy", getUpdateBy())
            .toString();
    }
}
