package com.zehong.system.domain;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 上图设备监测对象 t_map_device_monitor
 * 
 * @author zehong
 * @date 2022-10-08
 */
public class TMapDeviceMonitor extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 监测id */
    private Long monitorId;

    /** 监测值 */
    @Excel(name = "监测值")
    private BigDecimal monitorValue;

    /** 监测设备状态 */
    @Excel(name = "监测设备状态")
    private String monitorDeviceStatus;

    /** 监测设备编号 */
    @Excel(name = "监测设备编号")
    private String monitorDeviceNum;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    public void setMonitorId(Long monitorId) 
    {
        this.monitorId = monitorId;
    }

    public Long getMonitorId() 
    {
        return monitorId;
    }
    public void setMonitorValue(BigDecimal monitorValue) 
    {
        this.monitorValue = monitorValue;
    }

    public BigDecimal getMonitorValue() 
    {
        return monitorValue;
    }
    public void setMonitorDeviceStatus(String monitorDeviceStatus) 
    {
        this.monitorDeviceStatus = monitorDeviceStatus;
    }

    public String getMonitorDeviceStatus() 
    {
        return monitorDeviceStatus;
    }
    public void setMonitorDeviceNum(String monitorDeviceNum) 
    {
        this.monitorDeviceNum = monitorDeviceNum;
    }

    public String getMonitorDeviceNum() 
    {
        return monitorDeviceNum;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("monitorId", getMonitorId())
            .append("monitorValue", getMonitorValue())
            .append("monitorDeviceStatus", getMonitorDeviceStatus())
            .append("monitorDeviceNum", getMonitorDeviceNum())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remark", getRemark())
            .toString();
    }
}
