package com.zehong.system.domain;

import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;

/**
 * 上图设备信息对象 t_map_device_info
 * 
 * @author zehong
 * @date 2022-10-08
 */
public class TMapDeviceInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 上图设备id */
    private Long mapDeviceId;

    /** 上图设备名称 */
    @Excel(name = "上图设备名称")
    private String mapDeviceName;

    /** 设备类型：1.工业探测器 2.温度变送器 3.压力监测设备 4.液位探测器 5.摄像头 */
    @Excel(name = "设备类型：1.工业探测器 2.温度变送器 3.压力监测设备 4.液位探测器 5.摄像头")
    private String mapDeviceType;

    /** 设备编号 */
    @Excel(name = "设备编号")
    private String mapDeviceNum;

    /** 检测介质 */
    @Excel(name = "检测介质")
    private String mapDeviceMedium;

    /** 单位 */
    @Excel(name = "单位")
    private String mapDeviceUnit;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    //监测值
    private BigDecimal monitorValue;

    //设备状态
    private String monitorDeviceStatus;

    public BigDecimal getMonitorValue() {
        return monitorValue;
    }

    public void setMonitorValue(BigDecimal monitorValue) {
        this.monitorValue = monitorValue;
    }

    public String getMonitorDeviceStatus() {
        return monitorDeviceStatus;
    }

    public void setMonitorDeviceStatus(String monitorDeviceStatus) {
        this.monitorDeviceStatus = monitorDeviceStatus;
    }

    public void setMapDeviceId(Long mapDeviceId)
    {
        this.mapDeviceId = mapDeviceId;
    }

    public Long getMapDeviceId() 
    {
        return mapDeviceId;
    }
    public void setMapDeviceName(String mapDeviceName) 
    {
        this.mapDeviceName = mapDeviceName;
    }

    public String getMapDeviceName() 
    {
        return mapDeviceName;
    }
    public void setMapDeviceType(String mapDeviceType) 
    {
        this.mapDeviceType = mapDeviceType;
    }

    public String getMapDeviceType() 
    {
        return mapDeviceType;
    }
    public void setMapDeviceNum(String mapDeviceNum) 
    {
        this.mapDeviceNum = mapDeviceNum;
    }

    public String getMapDeviceNum() 
    {
        return mapDeviceNum;
    }
    public void setMapDeviceMedium(String mapDeviceMedium) 
    {
        this.mapDeviceMedium = mapDeviceMedium;
    }

    public String getMapDeviceMedium() 
    {
        return mapDeviceMedium;
    }
    public void setMapDeviceUnit(String mapDeviceUnit) 
    {
        this.mapDeviceUnit = mapDeviceUnit;
    }

    public String getMapDeviceUnit() 
    {
        return mapDeviceUnit;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("mapDeviceId", getMapDeviceId())
            .append("mapDeviceName", getMapDeviceName())
            .append("mapDeviceType", getMapDeviceType())
            .append("mapDeviceNum", getMapDeviceNum())
            .append("mapDeviceMedium", getMapDeviceMedium())
            .append("mapDeviceUnit", getMapDeviceUnit())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remark", getRemark())
            .toString();
    }
}
