package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 巡检点记录信息对象 t_inspect_work_point_recorde
 * 
 * @author zehong
 * @date 2022-06-21
 */
public class TInspectWorkPointRecorde extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 巡检点记录id */
    private Long pointId;

    /** 关联任务id */
    @Excel(name = "关联任务id")
    private Long workId;

    /** 巡检点id */
    @Excel(name = "巡检点id")
    private Long patrolId;

    @Excel(name = "巡检点")
    private String patrolName;

    /** 打卡地点 */
    @Excel(name = "打卡地点")
    private String punchPlace;

    /** 巡检参数 */
    @Excel(name = "巡检参数")
    private String patrolDetail;

    /** 打卡时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "打卡时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date punchTime;

    /** 巡检点状态：0.未打卡、1.已打卡 */
    @Excel(name = "巡检点状态：0.未打卡、1.已打卡")
    private String pointStatus;

    /** 反馈内容 */
    @Excel(name = "反馈内容")
    private String feedBook;

    /** 是否有异常：0.无、1.有 */
    @Excel(name = "是否有异常：0.无、1.有")
    private String isException;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setPointId(Long pointId) 
    {
        this.pointId = pointId;
    }

    public Long getPointId() 
    {
        return pointId;
    }
    public void setWorkId(Long workId)
    {
        this.workId = workId;
    }

    public Long getWorkId()
    {
        return workId;
    }
    public void setPatrolId(Long patrolId) 
    {
        this.patrolId = patrolId;
    }

    public Long getPatrolId() 
    {
        return patrolId;
    }

    public String getPatrolName() {
        return patrolName;
    }

    public void setPatrolName(String patrolName) {
        this.patrolName = patrolName;
    }
    public void setPunchPlace(String punchPlace)
    {
        this.punchPlace = punchPlace;
    }

    public String getPunchPlace() 
    {
        return punchPlace;
    }
    public void setPatrolDetail(String patrolDetail) 
    {
        this.patrolDetail = patrolDetail;
    }

    public String getPatrolDetail() 
    {
        return patrolDetail;
    }
    public void setPunchTime(Date punchTime) 
    {
        this.punchTime = punchTime;
    }

    public Date getPunchTime() 
    {
        return punchTime;
    }
    public void setPointStatus(String pointStatus) 
    {
        this.pointStatus = pointStatus;
    }

    public String getPointStatus() 
    {
        return pointStatus;
    }
    public void setFeedBook(String feedBook) 
    {
        this.feedBook = feedBook;
    }

    public String getFeedBook() 
    {
        return feedBook;
    }
    public void setIsException(String isException) 
    {
        this.isException = isException;
    }

    public String getIsException() 
    {
        return isException;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("pointId", getPointId())
            .append("workId", getWorkId())
            .append("patrolId", getPatrolId())
            .append("punchPlace", getPunchPlace())
            .append("patrolDetail", getPatrolDetail())
            .append("punchTime", getPunchTime())
            .append("pointStatus", getPointStatus())
            .append("feedBook", getFeedBook())
            .append("isException", getIsException())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
