package com.zehong.system.domain;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 隐患排查任务对象 t_hidden_trouble_work
 * 
 * @author zehong
 * @date 2022-07-11
 */
public class THiddenTroubleWork extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long workId;

    /** 父级计划id */
    @Excel(name = "父级计划id")
    private Long parentId;

    /** 隐患id */
    private Long bookId;
    @Excel(name = "隐患")
    private String troubleName;

    /** 任务周期 */
    @Excel(name = "任务周期")
    private Integer workCycle;

    /** 任务名称 */
    @Excel(name = "任务名称")
    private String workName;

    /** 任务排查类型 */
    @Excel(name = "任务排查类型")
    private Integer workType;

    /** 任务排查形式 */
    @Excel(name = "任务排查形式")
    private Integer workForm;

    /** 排查开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "排查开始时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date workBeginTime;

    /** 排查结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "排查结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date workEndTime;

    /** 实际完成时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "实际完成时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date finishTime;

    /** 任务期限 */
    @Excel(name = "任务期限")
    private Integer timeTerm;

    /** 任务范围 */
    @Excel(name = "任务范围")
    private String workRange;

    /** 责任部门 */
    private Long deptId;
    @Excel(name = "责任部门")
    private String deptName;

    /** 任务进展  */
    @Excel(name = "任务进展 ")
    private Integer workStep;

    /** 排查内容 */
    private String content;

    /**  0未删除 1已删除 */
    private Integer isDel;

    private List<THiddenTroubleWork> children;

    private Integer limits = 0;

    public Integer getLimits() {
        return limits;
    }

    public void setLimits(Integer limits) {
        this.limits = limits;
    }

    public List<THiddenTroubleWork> getChildren() {
        return children;
    }

    public void setChildren(List<THiddenTroubleWork> children) {
        this.children = children;
    }

    public void setWorkId(Long workId)
    {
        this.workId = workId;
    }

    public Long getWorkId() 
    {
        return workId;
    }
    public void setParentId(Long parentId) 
    {
        this.parentId = parentId;
    }

    public Long getParentId() 
    {
        return parentId;
    }
    public void setBookId(Long bookId) 
    {
        this.bookId = bookId;
    }

    public Long getBookId() 
    {
        return bookId;
    }
    public void setWorkCycle(Integer workCycle) 
    {
        this.workCycle = workCycle;
    }

    public Integer getWorkCycle() 
    {
        return workCycle;
    }
    public void setWorkName(String workName) 
    {
        this.workName = workName;
    }

    public String getWorkName() 
    {
        return workName;
    }
    public void setWorkType(Integer workType) 
    {
        this.workType = workType;
    }

    public Integer getWorkType() 
    {
        return workType;
    }
    public void setWorkForm(Integer workForm) 
    {
        this.workForm = workForm;
    }

    public Integer getWorkForm() 
    {
        return workForm;
    }
    public void setWorkBeginTime(Date workBeginTime) 
    {
        this.workBeginTime = workBeginTime;
    }

    public Date getWorkBeginTime() 
    {
        return workBeginTime;
    }
    public void setWorkEndTime(Date workEndTime) 
    {
        this.workEndTime = workEndTime;
    }

    public Date getWorkEndTime() 
    {
        return workEndTime;
    }
    public void setTimeTerm(Integer timeTerm) 
    {
        this.timeTerm = timeTerm;
    }

    public Integer getTimeTerm() 
    {
        return timeTerm;
    }
    public void setWorkRange(String workRange) 
    {
        this.workRange = workRange;
    }

    public String getWorkRange() 
    {
        return workRange;
    }
    public void setDeptId(Long deptId) 
    {
        this.deptId = deptId;
    }

    public Long getDeptId() 
    {
        return deptId;
    }
    public void setWorkStep(Integer workStep) 
    {
        this.workStep = workStep;
    }

    public Integer getWorkStep() 
    {
        return workStep;
    }
    public void setContent(String content) 
    {
        this.content = content;
    }

    public String getContent() 
    {
        return content;
    }
    public void setIsDel(Integer isDel) 
    {
        this.isDel = isDel;
    }

    public Date getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public Integer getIsDel()
    {
        return isDel;
    }

    public String getTroubleName() {
        return troubleName;
    }

    public void setTroubleName(String troubleName) {
        this.troubleName = troubleName;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("workId", getWorkId())
            .append("parentId", getParentId())
            .append("bookId", getBookId())
            .append("workCycle", getWorkCycle())
            .append("workName", getWorkName())
            .append("workType", getWorkType())
            .append("workForm", getWorkForm())
            .append("workBeginTime", getWorkBeginTime())
            .append("workEndTime", getWorkEndTime())
            .append("timeTerm", getTimeTerm())
            .append("workRange", getWorkRange())
            .append("deptId", getDeptId())
            .append("workStep", getWorkStep())
            .append("content", getContent())
            .append("createTime", getCreateTime())
            .append("createBy", getCreateBy())
            .append("isDel", getIsDel())
            .toString();
    }
}
