package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 排查评估对象 t_hidden_trouble_assessment
 * 
 * @author zehong
 * @date 2022-07-12
 */
public class THiddenTroubleAssessment extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long assessmentId;

    /** 排查任务id */
    @Excel(name = "排查任务id")
    private Long workId;

    /** 排查反馈内容 */
    @Excel(name = "排查反馈内容")
    private String checkFeedback;

    /** 现场图片或视频 */
    @Excel(name = "现场图片或视频")
    private String checkUrl;

    /** 排查时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "排查时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date checkTime;

    /** 排查人 */
    @Excel(name = "排查人")
    private String checkUser;

    /** 评估内容 */
    @Excel(name = "评估内容")
    private String assessmentContent;

    /** 评估时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "评估时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date assessmentTime;

    /** 评估人 */
    @Excel(name = "评估人")
    private String assessmentUser;

    /** 评估风险等级 */
    @Excel(name = "评估风险等级")
    private Integer assessmentLevel;

    /** 是否需要整改 0否 1是 */
    @Excel(name = "是否需要整改 0否 1是")
    private Integer isModify;

    /** 整改意见 */
    @Excel(name = "整改意见")
    private String modifyOpinion;

    /** 整改人 */
    @Excel(name = "整改人")
    private String modifyPeople;

    /** 整改人电话 */
    @Excel(name = "整改人电话")
    private String modifyPhone;

    /** 整改期限 */
    @Excel(name = "整改期限")
    private Integer modifyTerm;

    /** 整改开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "整改开始时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date modifyBegin;

    /** 整改结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "整改结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date modifyEnd;

    /** 整改是否完成 0否 1是 */
    @Excel(name = "整改是否完成 0否 1是")
    private Integer modifyComplete;

    private Integer updateType = 0;

    public Integer getUpdateType() {
        return updateType;
    }

    public void setUpdateType(Integer updateType) {
        this.updateType = updateType;
    }

    public void setAssessmentId(Long assessmentId)
    {
        this.assessmentId = assessmentId;
    }

    public Long getAssessmentId() 
    {
        return assessmentId;
    }
    public void setWorkId(Long workId) 
    {
        this.workId = workId;
    }

    public Long getWorkId() 
    {
        return workId;
    }
    public void setCheckFeedback(String checkFeedback) 
    {
        this.checkFeedback = checkFeedback;
    }

    public String getCheckFeedback() 
    {
        return checkFeedback;
    }
    public void setCheckUrl(String checkUrl) 
    {
        this.checkUrl = checkUrl;
    }

    public String getCheckUrl() 
    {
        return checkUrl;
    }
    public void setCheckTime(Date checkTime) 
    {
        this.checkTime = checkTime;
    }

    public Date getCheckTime() 
    {
        return checkTime;
    }
    public void setCheckUser(String checkUser) 
    {
        this.checkUser = checkUser;
    }

    public String getCheckUser() 
    {
        return checkUser;
    }
    public void setAssessmentContent(String assessmentContent) 
    {
        this.assessmentContent = assessmentContent;
    }

    public String getAssessmentContent() 
    {
        return assessmentContent;
    }
    public void setAssessmentTime(Date assessmentTime) 
    {
        this.assessmentTime = assessmentTime;
    }

    public Date getAssessmentTime() 
    {
        return assessmentTime;
    }
    public void setAssessmentUser(String assessmentUser) 
    {
        this.assessmentUser = assessmentUser;
    }

    public String getAssessmentUser() 
    {
        return assessmentUser;
    }
    public void setAssessmentLevel(Integer assessmentLevel) 
    {
        this.assessmentLevel = assessmentLevel;
    }

    public Integer getAssessmentLevel() 
    {
        return assessmentLevel;
    }
    public void setIsModify(Integer isModify) 
    {
        this.isModify = isModify;
    }

    public Integer getIsModify() 
    {
        return isModify;
    }
    public void setModifyOpinion(String modifyOpinion) 
    {
        this.modifyOpinion = modifyOpinion;
    }

    public String getModifyOpinion() 
    {
        return modifyOpinion;
    }
    public void setModifyPeople(String modifyPeople) 
    {
        this.modifyPeople = modifyPeople;
    }

    public String getModifyPeople() 
    {
        return modifyPeople;
    }
    public void setModifyPhone(String modifyPhone) 
    {
        this.modifyPhone = modifyPhone;
    }

    public String getModifyPhone() 
    {
        return modifyPhone;
    }
    public void setModifyTerm(Integer modifyTerm) 
    {
        this.modifyTerm = modifyTerm;
    }

    public Integer getModifyTerm() 
    {
        return modifyTerm;
    }
    public void setModifyBegin(Date modifyBegin) 
    {
        this.modifyBegin = modifyBegin;
    }

    public Date getModifyBegin() 
    {
        return modifyBegin;
    }
    public void setModifyEnd(Date modifyEnd) 
    {
        this.modifyEnd = modifyEnd;
    }

    public Date getModifyEnd() 
    {
        return modifyEnd;
    }
    public void setModifyComplete(Integer modifyComplete) 
    {
        this.modifyComplete = modifyComplete;
    }

    public Integer getModifyComplete() 
    {
        return modifyComplete;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("assessmentId", getAssessmentId())
            .append("workId", getWorkId())
            .append("checkFeedback", getCheckFeedback())
            .append("checkUrl", getCheckUrl())
            .append("checkTime", getCheckTime())
            .append("checkUser", getCheckUser())
            .append("assessmentContent", getAssessmentContent())
            .append("assessmentTime", getAssessmentTime())
            .append("assessmentUser", getAssessmentUser())
            .append("assessmentLevel", getAssessmentLevel())
            .append("isModify", getIsModify())
            .append("modifyOpinion", getModifyOpinion())
            .append("modifyPeople", getModifyPeople())
            .append("modifyPhone", getModifyPhone())
            .append("modifyTerm", getModifyTerm())
            .append("modifyBegin", getModifyBegin())
            .append("modifyEnd", getModifyEnd())
            .append("modifyComplete", getModifyComplete())
            .toString();
    }
}
