package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 隐患排查库对象 t_hidden_library
 * 
 * @author zehong
 * @date 2022-07-13
 */
public class THiddenLibrary extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long libraryId;

    /** 排查库标题 */
    @Excel(name = "排查库标题")
    private String libraryName;

    /** 排查库内容 */
    @Excel(name = "排查库内容")
    private String libraryContent;

    public void setLibraryId(Long libraryId) 
    {
        this.libraryId = libraryId;
    }

    public Long getLibraryId() 
    {
        return libraryId;
    }
    public void setLibraryName(String libraryName) 
    {
        this.libraryName = libraryName;
    }

    public String getLibraryName() 
    {
        return libraryName;
    }
    public void setLibraryContent(String libraryContent) 
    {
        this.libraryContent = libraryContent;
    }

    public String getLibraryContent() 
    {
        return libraryContent;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("libraryId", getLibraryId())
            .append("libraryName", getLibraryName())
            .append("libraryContent", getLibraryContent())
            .toString();
    }
}
