package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 企业制度对象 t_enterprise_system
 *
 * @author zehong
 * @date 2022-10-06
 */
public class TEnterpriseSystem extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 制度id */
    private Long systemId;

    /** 制度标题 */
    @Excel(name = "制度标题")
    private String systemTitle;

    /** 制度类型（1企业规章制度，2法律法规） */
    @Excel(name = "制度类型", readConverterExp = "1=企业规章制度，2法律法规")
    private String systemType;

    /** 层级：1.国家法律 2.行政法规 3.部委规章 4.地方性法规 5.国家标准 6.行业标准 7.地方标准 8.国际通用规则 9.政策解读 10.其他 */
    @Excel(name = "层级：1.国家法律 2.行政法规 3.部委规章 4.地方性法规 5.国家标准 6.行业标准 7.地方标准 8.国际通用规则 9.政策解读 10.其他")
    private String hierarchy;

    /** 文号 */
    @Excel(name = "文号")
    private String referenceNum;

    /** 颁布部门 */
    @Excel(name = "颁布部门")
    private String issueDept;

    /** 有效性：1.现行有效 2.尚未实施 3.废除 4.废止 */
    @Excel(name = "有效性：1.现行有效 2.尚未实施 3.废除 4.废止")
    private String availability;

    /** 内容分类（仅用于企业规章制度分类） */
    @Excel(name = "内容分类", readConverterExp = "仅=用于企业规章制度分类")
    private String contentType;

    /** 内容 */
    @Excel(name = "内容")
    private String content;

    /** 文件名称 */
    @Excel(name = "文件名称")
    private String fileName;

    /** 文件路径 */
    @Excel(name = "文件路径")
    private String fileUrl;

    /** 状态（0待发布，1待审批，2审批通过，3作废） */
    @Excel(name = "状态", readConverterExp = "0=待发布，1待审批，2审批通过，3作废")
    private String status;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    public void setSystemId(Long systemId)
    {
        this.systemId = systemId;
    }

    public Long getSystemId()
    {
        return systemId;
    }
    public void setSystemTitle(String systemTitle)
    {
        this.systemTitle = systemTitle;
    }

    public String getSystemTitle()
    {
        return systemTitle;
    }
    public void setSystemType(String systemType)
    {
        this.systemType = systemType;
    }

    public String getSystemType()
    {
        return systemType;
    }
    public void setHierarchy(String hierarchy)
    {
        this.hierarchy = hierarchy;
    }

    public String getHierarchy()
    {
        return hierarchy;
    }
    public void setReferenceNum(String referenceNum)
    {
        this.referenceNum = referenceNum;
    }

    public String getReferenceNum()
    {
        return referenceNum;
    }
    public void setIssueDept(String issueDept)
    {
        this.issueDept = issueDept;
    }

    public String getIssueDept()
    {
        return issueDept;
    }
    public void setAvailability(String availability)
    {
        this.availability = availability;
    }

    public String getAvailability()
    {
        return availability;
    }
    public void setContentType(String contentType)
    {
        this.contentType = contentType;
    }

    public String getContentType()
    {
        return contentType;
    }
    public void setContent(String content)
    {
        this.content = content;
    }

    public String getContent()
    {
        return content;
    }
    public void setFileName(String fileName)
    {
        this.fileName = fileName;
    }

    public String getFileName()
    {
        return fileName;
    }
    public void setFileUrl(String fileUrl)
    {
        this.fileUrl = fileUrl;
    }

    public String getFileUrl()
    {
        return fileUrl;
    }
    public void setStatus(String status)
    {
        this.status = status;
    }

    public String getStatus()
    {
        return status;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("systemId", getSystemId())
                .append("systemTitle", getSystemTitle())
                .append("systemType", getSystemType())
                .append("hierarchy", getHierarchy())
                .append("referenceNum", getReferenceNum())
                .append("issueDept", getIssueDept())
                .append("availability", getAvailability())
                .append("contentType", getContentType())
                .append("content", getContent())
                .append("fileName", getFileName())
                .append("fileUrl", getFileUrl())
                .append("createBy", getCreateBy())
                .append("createTime", getCreateTime())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .append("status", getStatus())
                .append("isDel", getIsDel())
                .append("remark", getRemark())
                .toString();
    }
}
