package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 应急演练对象 t_emergency_drill
 * 
 * @author zehong
 * @date 2022-06-29
 */
public class TEmergencyDrill extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long drillId;

    /** 演练名称 */
    @Excel(name = "演练名称")
    private String drillName;

    /** 演练地址 */
    @Excel(name = "演练地址")
    private String drillAddress;

    /** 主办单位 */
    @Excel(name = "主办单位")
    private String drillUnit;

    /** 演练时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "演练时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date drillTime;

    /** 演练类型 */
    @Excel(name = "演练类型")
    private Integer drillType;

    /** 演练形式 */
    @Excel(name = "演练形式")
    private Integer drillForm;

    /** 演练目的 */
    @Excel(name = "演练目的")
    private String drillObjective;

    /** 参演人员 */
    @Excel(name = "参演人员")
    private String drillPeople;

    /** 演练内容 */
    @Excel(name = "演练内容")
    private String drillContent;

    /** 评估 */
    @Excel(name = "评估")
    private String assessment;

    /** 删除 0否 1是 */
    private Integer isDel;

    public void setDrillId(Long drillId) 
    {
        this.drillId = drillId;
    }

    public Long getDrillId() 
    {
        return drillId;
    }
    public void setDrillName(String drillName) 
    {
        this.drillName = drillName;
    }

    public String getDrillName() 
    {
        return drillName;
    }
    public void setDrillAddress(String drillAddress) 
    {
        this.drillAddress = drillAddress;
    }

    public String getDrillAddress() 
    {
        return drillAddress;
    }
    public void setDrillUnit(String drillUnit) 
    {
        this.drillUnit = drillUnit;
    }

    public String getDrillUnit() 
    {
        return drillUnit;
    }
    public void setDrillTime(Date drillTime) 
    {
        this.drillTime = drillTime;
    }

    public Date getDrillTime() 
    {
        return drillTime;
    }
    public void setDrillType(Integer drillType) 
    {
        this.drillType = drillType;
    }

    public Integer getDrillType() 
    {
        return drillType;
    }
    public void setDrillForm(Integer drillForm) 
    {
        this.drillForm = drillForm;
    }

    public Integer getDrillForm() 
    {
        return drillForm;
    }
    public void setDrillObjective(String drillObjective) 
    {
        this.drillObjective = drillObjective;
    }

    public String getDrillObjective() 
    {
        return drillObjective;
    }
    public void setDrillPeople(String drillPeople) 
    {
        this.drillPeople = drillPeople;
    }

    public String getDrillPeople() 
    {
        return drillPeople;
    }
    public void setDrillContent(String drillContent) 
    {
        this.drillContent = drillContent;
    }

    public String getDrillContent() 
    {
        return drillContent;
    }
    public void setAssessment(String assessment) 
    {
        this.assessment = assessment;
    }

    public String getAssessment() 
    {
        return assessment;
    }
    public void setIsDel(Integer isDel) 
    {
        this.isDel = isDel;
    }

    public Integer getIsDel() 
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("drillId", getDrillId())
            .append("drillName", getDrillName())
            .append("drillAddress", getDrillAddress())
            .append("drillUnit", getDrillUnit())
            .append("drillTime", getDrillTime())
            .append("drillType", getDrillType())
            .append("drillForm", getDrillForm())
            .append("drillObjective", getDrillObjective())
            .append("drillPeople", getDrillPeople())
            .append("drillContent", getDrillContent())
            .append("assessment", getAssessment())
            .append("createTime", getCreateTime())
            .append("createBy", getCreateBy())
            .append("isDel", getIsDel())
            .toString();
    }
}
