package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 应急通讯人员管理对象 t_emergency_crew
 *
 * @author zehong
 * @date 2022-06-29
 */
public class TEmergencyCrew extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 应急通讯主键 */
    private Long communicationId;

    /** 人员名称 */
    @Excel(name = "人员名称")
    private String personnelName;

    /** 职务id  关联岗位管理表 */
    private Long postId;

    /** 人员职务*/
    @Excel(name = "人员职务")
    private String post;

    /** 人员职责 */
    @Excel(name = "人员职责")
    private String personnelDuty;

    /** 人员电话号码 */
    @Excel(name = "人员电话号码")
    private String personnelTelephoneNumber;

    /** 应急队伍id */
    private Long emergencyTeamId;

    /** 是否删除 */
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getPost() {
        return post;
    }

    public void setPost(String post) {
        this.post = post;
    }

    public void setCommunicationId(Long communicationId)
    {
        this.communicationId = communicationId;
    }

    public Long getCommunicationId()
    {
        return communicationId;
    }
    public void setPersonnelName(String personnelName)
    {
        this.personnelName = personnelName;
    }

    public String getPersonnelName()
    {
        return personnelName;
    }
    public void setPostId(Long postId)
    {
        this.postId = postId;
    }

    public Long getPostId()
    {
        return postId;
    }
    public void setPersonnelDuty(String personnelDuty)
    {
        this.personnelDuty = personnelDuty;
    }

    public String getPersonnelDuty()
    {
        return personnelDuty;
    }
    public void setPersonnelTelephoneNumber(String personnelTelephoneNumber)
    {
        this.personnelTelephoneNumber = personnelTelephoneNumber;
    }

    public String getPersonnelTelephoneNumber()
    {
        return personnelTelephoneNumber;
    }
    public void setEmergencyTeamId(Long emergencyTeamId)
    {
        this.emergencyTeamId = emergencyTeamId;
    }

    public Long getEmergencyTeamId()
    {
        return emergencyTeamId;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }
    public void setRemarks(String remarks)
    {
        this.remarks = remarks;
    }

    public String getRemarks()
    {
        return remarks;
    }

    @Override
    public String toString() {
        return "TEmergencyCrew{" +
                "communicationId=" + communicationId +
                ", personnelName='" + personnelName + '\'' +
                ", postId=" + postId +
                ", post='" + post + '\'' +
                ", personnelDuty='" + personnelDuty + '\'' +
                ", personnelTelephoneNumber='" + personnelTelephoneNumber + '\'' +
                ", emergencyTeamId=" + emergencyTeamId +
                ", isDel='" + isDel + '\'' +
                ", remarks='" + remarks + '\'' +
                '}';
    }
}
