package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 报警记录对象 t_device_alarm_info
 * 
 * @author zehong
 * @date 2022-07-04
 */
public class TDeviceAlarmInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long alarmId;

    /** 关联设备id */
    @Excel(name = "关联设备id")
    private String relationDeviceId;

    private String deviceName;

    /** 预警类型 */
    @Excel(name = "预警类型")
    private Integer alarmContent;

    /** 报警级别 */
    @Excel(name = "报警级别")
    private Integer alarmLevel;

    /** 预警开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "预警开始时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date alarmBeginTime;

    /** 预警结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "预警结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date alarmEndTime;

    /** 报警状态 */
    @Excel(name = "报警状态")
    private String alarmStatus;

    /** 预警图片 */
    @Excel(name = "预警图片")
    private String alarmImageUrl;

    /** 预警值 */
    @Excel(name = "预警值")
    private String alarmVaule;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;


    public String getDeviceName() {
        return deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public void setAlarmId(Long alarmId)
    {
        this.alarmId = alarmId;
    }

    public Long getAlarmId() 
    {
        return alarmId;
    }
    public void setRelationDeviceId(String relationDeviceId)
    {
        this.relationDeviceId = relationDeviceId;
    }

    public String getRelationDeviceId()
    {
        return relationDeviceId;
    }
    public void setAlarmContent(Integer alarmContent) 
    {
        this.alarmContent = alarmContent;
    }

    public Integer getAlarmContent() 
    {
        return alarmContent;
    }
    public void setAlarmLevel(Integer alarmLevel) 
    {
        this.alarmLevel = alarmLevel;
    }

    public Integer getAlarmLevel() 
    {
        return alarmLevel;
    }
    public void setAlarmBeginTime(Date alarmBeginTime) 
    {
        this.alarmBeginTime = alarmBeginTime;
    }

    public Date getAlarmBeginTime() 
    {
        return alarmBeginTime;
    }
    public void setAlarmEndTime(Date alarmEndTime) 
    {
        this.alarmEndTime = alarmEndTime;
    }

    public Date getAlarmEndTime() 
    {
        return alarmEndTime;
    }
    public void setAlarmStatus(String alarmStatus) 
    {
        this.alarmStatus = alarmStatus;
    }

    public String getAlarmStatus() 
    {
        return alarmStatus;
    }
    public void setAlarmImageUrl(String alarmImageUrl) 
    {
        this.alarmImageUrl = alarmImageUrl;
    }

    public String getAlarmImageUrl() 
    {
        return alarmImageUrl;
    }
    public void setAlarmVaule(String alarmVaule) 
    {
        this.alarmVaule = alarmVaule;
    }

    public String getAlarmVaule() 
    {
        return alarmVaule;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("alarmId", getAlarmId())
            .append("relationDeviceId", getRelationDeviceId())
            .append("alarmContent", getAlarmContent())
            .append("alarmLevel", getAlarmLevel())
            .append("alarmBeginTime", getAlarmBeginTime())
            .append("alarmEndTime", getAlarmEndTime())
            .append("alarmStatus", getAlarmStatus())
            .append("alarmImageUrl", getAlarmImageUrl())
            .append("alarmVaule", getAlarmVaule())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
