package com.zehong.web.controller.train;

import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.ServletUtils;
import com.zehong.framework.web.service.TokenService;
import com.zehong.system.domain.vo.UserCourseVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TTrainCourse;
import com.zehong.system.service.ITTrainCourseService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 培训课程Controller
 * 
 * @author zehong
 * @date 2022-09-19
 */
@Api("课程管理")
@RestController
@RequestMapping("/system/course")
public class TTrainCourseController extends BaseController
{
    @Autowired
    private ITTrainCourseService tTrainCourseService;
    @Autowired
    private TokenService tokenService;

    /**
     * 查询培训课程列表
     */
    @ApiOperation("课程列表")
    @GetMapping("/list")
    public TableDataInfo list(TTrainCourse tTrainCourse)
    {
        startPage();
        tTrainCourse.setIsDel(0);
        List<TTrainCourse> list = tTrainCourseService.selectTTrainCourseList(tTrainCourse);
        return getDataTable(list);
    }

    @ApiOperation("用户课程列表")
    @GetMapping("/userCourseList")
    public TableDataInfo userCourseList(Integer type){
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();
        startPage();
        List<UserCourseVo> list = tTrainCourseService.userCourseList(user.getUserId(),type);
        return getDataTable(list);
    }

    @ApiOperation("用户课程考试")
    @GetMapping("/examination")
    public AjaxResult examination(Long userCourseId,String answers){

        Map<String,Object> map = tTrainCourseService.examination(userCourseId, answers.split(","));
        return AjaxResult.success(map);
    }
    /**
     * 导出培训课程列表
     */
    //@PreAuthorize("@ss.hasPermi('system:course:export')")
    @Log(title = "培训课程", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TTrainCourse tTrainCourse)
    {
        List<TTrainCourse> list = tTrainCourseService.selectTTrainCourseList(tTrainCourse);
        ExcelUtil<TTrainCourse> util = new ExcelUtil<TTrainCourse>(TTrainCourse.class);
        return util.exportExcel(list, "培训课程数据");
    }

    /**
     * 获取培训课程详细信息
     */
    @ApiOperation("课程详情")
    @GetMapping(value = "/{courseId}")
    public AjaxResult getInfo(@PathVariable("courseId") Long courseId)
    {
        return AjaxResult.success(tTrainCourseService.selectTTrainCourseById(courseId));
    }

    /**
     * 获取培训课程详细信息
     */
    @ApiOperation("课程发布")
    @GetMapping("/release")
    public AjaxResult release( Long courseId)
    {
        return toAjax(tTrainCourseService.selectTTrainCourseRelease (courseId));
    }

    /**
     * 新增培训课程
     */
    @ApiOperation("新增课程")
    @Log(title = "培训课程", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TTrainCourse tTrainCourse)
    {
        return AjaxResult.success(tTrainCourseService.insertTTrainCourse(tTrainCourse));
    }

    /**
     * 修改培训课程
     */
    @ApiOperation("修改课程")
    @Log(title = "培训课程", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TTrainCourse tTrainCourse)
    {
        return toAjax(tTrainCourseService.updateTTrainCourse(tTrainCourse));
    }

    /**
     * 删除培训课程
     */
    @ApiOperation("删除课程")
    @Log(title = "培训课程", businessType = BusinessType.DELETE)
	@DeleteMapping("/{courseId}")
    public AjaxResult remove(@PathVariable Long courseId)
    {
        TTrainCourse tTrainCourse = new TTrainCourse();
        tTrainCourse.setCourseId(courseId);
        tTrainCourse.setIsDel(1);
        return toAjax(tTrainCourseService.updateTTrainCourse(tTrainCourse));
    }
}
