package com.zehong.web.controller.system;

import java.util.List;

import com.zehong.framework.systemsetting.SystemSetting;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.SysSetting;
import com.zehong.system.service.ISysSettingService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 系统参数配置Controller
 * 
 * @author zehong
 * @date 2021-11-23
 */
@RestController
@RequestMapping("/system/setting")
public class SysSettingController extends BaseController
{
    @Autowired
    private ISysSettingService sysSettingService;

    @Autowired
    private SystemSetting systemSetting;

    /**
     * 查询系统参数配置列表
     */
    //@PreAuthorize("@ss.hasPermi('system:setting:list')")
    @GetMapping("/list")
    public TableDataInfo list(SysSetting sysSetting)
    {
        startPage();
        List<SysSetting> list = sysSettingService.selectSysSettingList(sysSetting);
        return getDataTable(list);
    }

    /**
     * 导出系统参数配置列表
     */
    //@PreAuthorize("@ss.hasPermi('system:setting:export')")
    @Log(title = "系统参数配置", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(SysSetting sysSetting)
    {
        List<SysSetting> list = sysSettingService.selectSysSettingList(sysSetting);
        ExcelUtil<SysSetting> util = new ExcelUtil<SysSetting>(SysSetting.class);
        return util.exportExcel(list, "系统参数配置数据");
    }

    /**
     * 获取系统参数配置详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:setting:query')")
    @GetMapping(value = "/{systemId}")
    public AjaxResult getInfo(@PathVariable("systemId") Integer systemId)
    {
        return AjaxResult.success(sysSettingService.selectSysSettingById(systemId));
    }

    /**
     * 新增系统参数配置
     */
    //@PreAuthorize("@ss.hasPermi('system:setting:add')")
    @Log(title = "系统参数配置", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysSetting sysSetting)
    {
        return toAjax(sysSettingService.insertSysSetting(sysSetting));
    }

    /**
     * 修改系统参数配置
     */
    //@PreAuthorize("@ss.hasPermi('system:setting:edit')")
    @Log(title = "系统参数配置", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysSetting sysSetting)
    {
        return toAjax(sysSettingService.updateSysSetting(sysSetting));
    }

    /**
     * 删除系统参数配置
     */
    //@PreAuthorize("@ss.hasPermi('system:setting:remove')")
    @Log(title = "系统参数配置", businessType = BusinessType.DELETE)
	@DeleteMapping("/{systemIds}")
    public AjaxResult remove(@PathVariable Integer[] systemIds)
    {
        return toAjax(sysSettingService.deleteSysSettingByIds(systemIds));
    }

    /**
     * 刷新系统参数
     */
    @GetMapping("/refreshSystemSetting")
    public AjaxResult refreshSystemSetting(){
        systemSetting.freshSettings();
        return AjaxResult.success(systemSetting.getSystemWebSetting());
    }

}
