package com.zehong.web.controller.safetyManagement;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TInvestment;
import com.zehong.system.service.ITInvestmentService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 投入台账Controller
 * 
 * @author zehong
 * @date 2022-06-24
 */
@RestController
@RequestMapping("/safetyManagement/investment")
public class TInvestmentController extends BaseController
{
    @Autowired
    private ITInvestmentService tInvestmentService;

    /**
     * 查询投入台账列表
     */
    //@PreAuthorize("@ss.hasPermi('safetyManagement:investment:list')")
    @GetMapping("/list")
    public TableDataInfo list(TInvestment tInvestment)
    {
        startPage();
        List<TInvestment> list = tInvestmentService.selectTInvestmentList(tInvestment);
        return getDataTable(list);
    }

    /**
     * 导出投入台账列表
     */
    @Log(title = "投入台账", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TInvestment tInvestment)
    {
        List<TInvestment> list = tInvestmentService.selectTInvestmentList(tInvestment);
        ExcelUtil<TInvestment> util = new ExcelUtil<TInvestment>(TInvestment.class);
        return util.exportExcel(list, "投入台账数据");
    }

    /**
     * 获取投入台账详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tInvestmentService.selectTInvestmentById(id));
    }

    /**
     * 新增投入台账
     */
    @Log(title = "投入台账", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TInvestment tInvestment)
    {
        return toAjax(tInvestmentService.insertTInvestment(tInvestment));
    }

    /**
     * 修改投入台账
     */
    @Log(title = "投入台账", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TInvestment tInvestment)
    {
        return toAjax(tInvestmentService.updateTInvestment(tInvestment));
    }

    /**
     * 删除投入台账
     */
    @Log(title = "投入台账", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tInvestmentService.deleteTInvestmentByIds(ids));
    }
}
