package com.zehong.web.controller.safetyManagement;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TEnterpriseSystem;
import com.zehong.system.service.ITEnterpriseSystemService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 企业制度管理Controller
 * 
 * @author zehong
 * @date 2022-06-21
 */
@RestController
@RequestMapping("/safetyManagement/enterpriseSystem")
public class TEnterpriseSystemController extends BaseController
{
    @Autowired
    private ITEnterpriseSystemService tEnterpriseSystemService;

    /**
     * 查询企业制度管理列表
     */
    //@PreAuthorize("@ss.hasPermi('safetyManagement:enterpriseSystem:list')")
    @GetMapping("/list")
    public TableDataInfo list(TEnterpriseSystem tEnterpriseSystem)
    {
        startPage();
        List<TEnterpriseSystem> list = tEnterpriseSystemService.selectTEnterpriseSystemList(tEnterpriseSystem);
        return getDataTable(list);
    }

    /**
     * 导出企业制度管理列表
     */
    @Log(title = "企业制度管理", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TEnterpriseSystem tEnterpriseSystem)
    {
        List<TEnterpriseSystem> list = tEnterpriseSystemService.selectTEnterpriseSystemList(tEnterpriseSystem);
        ExcelUtil<TEnterpriseSystem> util = new ExcelUtil<TEnterpriseSystem>(TEnterpriseSystem.class);
        return util.exportExcel(list, "企业制度管理数据");
    }

    /**
     * 获取企业制度管理详细信息
     */
    @GetMapping(value = "/{systemId}")
    public AjaxResult getInfo(@PathVariable("systemId") Long systemId)
    {
        return AjaxResult.success(tEnterpriseSystemService.selectTEnterpriseSystemById(systemId));
    }

    /**
     * 新增企业制度管理
     */
    @Log(title = "企业制度管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TEnterpriseSystem tEnterpriseSystem)
    {
        return toAjax(tEnterpriseSystemService.insertTEnterpriseSystem(tEnterpriseSystem));
    }

    /**
     * 修改企业制度管理
     */
    @Log(title = "企业制度管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TEnterpriseSystem tEnterpriseSystem)
    {
        return toAjax(tEnterpriseSystemService.updateTEnterpriseSystem(tEnterpriseSystem));
    }

    /**
     * 删除企业制度管理
     */
    @Log(title = "企业制度管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{systemIds}")
    public AjaxResult remove(@PathVariable Long[] systemIds)
    {
        return toAjax(tEnterpriseSystemService.deleteTEnterpriseSystemByIds(systemIds));
    }
}
