package com.zehong.web.controller.resources;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TEmergencyDrill;
import com.zehong.system.service.ITEmergencyDrillService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 应急演练Controller
 * 
 * @author zehong
 * @date 2022-06-29
 */
@RestController
@RequestMapping("/system/drill")
public class TEmergencyDrillController extends BaseController
{
    @Autowired
    private ITEmergencyDrillService tEmergencyDrillService;

    /**
     * 查询应急演练列表
     */
    //@PreAuthorize("@ss.hasPermi('system:drill:list')")
    @GetMapping("/list")
    public TableDataInfo list(TEmergencyDrill tEmergencyDrill)
    {
        startPage();
        List<TEmergencyDrill> list = tEmergencyDrillService.selectTEmergencyDrillList(tEmergencyDrill);
        return getDataTable(list);
    }

    /**
     * 导出应急演练列表
     */
    //@PreAuthorize("@ss.hasPermi('system:drill:export')")
    @Log(title = "应急演练", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TEmergencyDrill tEmergencyDrill)
    {
        List<TEmergencyDrill> list = tEmergencyDrillService.selectTEmergencyDrillList(tEmergencyDrill);
        ExcelUtil<TEmergencyDrill> util = new ExcelUtil<TEmergencyDrill>(TEmergencyDrill.class);
        return util.exportExcel(list, "应急演练数据");
    }

    /**
     * 获取应急演练详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:drill:query')")
    @GetMapping(value = "/{drillId}")
    public AjaxResult getInfo(@PathVariable("drillId") Long drillId)
    {
        return AjaxResult.success(tEmergencyDrillService.selectTEmergencyDrillById(drillId));
    }

    /**
     * 新增应急演练
     */
    //@PreAuthorize("@ss.hasPermi('system:drill:add')")
    @Log(title = "应急演练", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TEmergencyDrill tEmergencyDrill)
    {
        return toAjax(tEmergencyDrillService.insertTEmergencyDrill(tEmergencyDrill));
    }

    /**
     * 修改应急演练
     */
    //@PreAuthorize("@ss.hasPermi('system:drill:edit')")
    @Log(title = "应急演练", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TEmergencyDrill tEmergencyDrill)
    {
        return toAjax(tEmergencyDrillService.updateTEmergencyDrill(tEmergencyDrill));
    }

    /**
     * 删除应急演练
     */
    //@PreAuthorize("@ss.hasPermi('system:drill:remove')")
    @Log(title = "应急演练", businessType = BusinessType.DELETE)
	@DeleteMapping("/{drillIds}")
    public AjaxResult remove(@PathVariable Long[] drillIds)
    {
        return toAjax(tEmergencyDrillService.deleteTEmergencyDrillByIds(drillIds));
    }
}
